/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class OpenFilesTest {
    private static List<String> listOpenFiles(File dir) throws IOException, InterruptedException {
        int processId = OS.getProcessId();
        ArrayList<String> fileList = new ArrayList<String>();
        Process pmap = new ProcessBuilder("lsof", "-p", Integer.toString(processId), dir.getAbsolutePath()).start();
        pmap.waitFor();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(pmap.getInputStream()));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.contains(".cq4")) continue;
                fileList.add(line);
            }
        }
        return fileList;
    }

    @Ignore(value="long running test")
    @Test
    public void test() throws IOException, InterruptedException {
        File tmp = new File("/tmp/tmp");
        try (SingleChronicleQueue q = ChronicleQueueBuilder.single((File)tmp).rollCycle((RollCycle)RollCycles.TEST_SECONDLY).build();){
            ExcerptAppender appender = q.acquireAppender();
            for (int i = 0; i < 10; ++i) {
                try (DocumentContext dc = appender.writingDocument();){
                    dc.wire().write((CharSequence)"hello").text("world");
                }
                Thread.sleep(1000L);
            }
            this.createTailer(q);
            long start = System.currentTimeMillis();
            Thread.sleep(5000L);
            System.out.println("-----");
            List<String> mappedQueueFileCount = OpenFilesTest.listOpenFiles(tmp);
            Assert.assertTrue((!mappedQueueFileCount.isEmpty() ? 1 : 0) != 0);
            this.removeDirectoryListing(mappedQueueFileCount);
            for (String s : mappedQueueFileCount) {
                System.out.println(s);
            }
            System.out.println("");
            long pause = 1000L - (System.currentTimeMillis() - start);
            if (pause > 0L) {
                Thread.sleep(pause);
            }
        }
        List<String> mappedQueueFileCount = OpenFilesTest.listOpenFiles(tmp);
        Assert.assertTrue((!mappedQueueFileCount.isEmpty() ? 1 : 0) != 0);
        Runtime.getRuntime().gc();
        System.runFinalization();
        List<String> listFileHandles = OpenFilesTest.listOpenFiles(tmp);
        Assert.assertTrue((boolean)listFileHandles.isEmpty());
        System.out.println(listFileHandles);
    }

    private void createTailer(SingleChronicleQueue q) {
        ExcerptTailer tailer = q.createTailer();
        while (true) {
            DocumentContext dc = tailer.readingDocument();
            Throwable throwable = null;
            try {
                if (!dc.isPresent()) break;
                Assert.assertEquals((Object)"world", (Object)dc.wire().read("hello").text());
                continue;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dc == null) continue;
                if (throwable != null) {
                    try {
                        dc.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dc.close();
                continue;
            }
            break;
        }
    }

    private void removeDirectoryListing(List<String> mappedQueueFileCount) {
        Iterator<String> iterator = mappedQueueFileCount.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().endsWith("directory-listing.cq4t")) continue;
            iterator.remove();
        }
    }
}

