/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Memory;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;

public class BenchmarkMain {
    static int throughput = Integer.getInteger("throughput", 250);
    static int runtime = Integer.getInteger("runtime", 300);
    static String basePath = System.getProperty("path", OS.TMP);
    static volatile long writeCount;

    public static void main(String[] args) {
        System.out.println("-Dthroughput=" + throughput + " -Druntime=" + runtime + " -Dpath=" + basePath);
        MappedFile.warmup();
        System.out.println("Warming up");
        BenchmarkMain.benchmark(128);
        System.out.println("Warmed up");
        for (int size = 64; size <= 0x1000000; size *= 4) {
            BenchmarkMain.benchmark(size);
        }
    }

    static void benchmark(int messageSize) {
        Histogram writeTime = new Histogram(32, 7);
        Histogram transportTime = new Histogram(32, 7);
        Histogram readTime = new Histogram(32, 7);
        String path = basePath + "/test-q-" + messageSize;
        SingleChronicleQueue queue = BenchmarkMain.createQueue(path);
        Thread pretoucher = new Thread(() -> {
            ExcerptAppender appender = queue.acquireAppender();
            Thread thread = Thread.currentThread();
            while (!thread.isInterrupted()) {
                appender.pretouch();
                Jvm.pause(10L);
            }
        });
        pretoucher.setDaemon(true);
        pretoucher.start();
        Thread reader = new Thread(() -> {
            try (SingleChronicleQueue queue2 = BenchmarkMain.createQueue(path);){
                ExcerptTailer tailer = queue2.createTailer().toEnd();
                Thread thread = Thread.currentThread();
                while (!thread.isInterrupted()) {
                    Jvm.safepoint();
                    DocumentContext dc = tailer.readingDocument();
                    Throwable throwable = null;
                    try {
                        Jvm.safepoint();
                        if (!dc.isPresent()) continue;
                        long transport = System.nanoTime();
                        Jvm.safepoint();
                        Wire wire = dc.wire();
                        Bytes<?> bytes = wire.bytes();
                        long start = BenchmarkMain.readMessage(bytes);
                        long end = System.nanoTime();
                        transportTime.sample(transport - start);
                        readTime.sample(end - transport);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dc == null) continue;
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dc.close();
                        continue;
                    }
                    Jvm.safepoint();
                }
            }
        });
        reader.start();
        Jvm.pause(250L);
        long next = System.nanoTime();
        long end = (long)((double)next + (double)runtime * 1.0E9);
        ExcerptAppender appender = queue.acquireAppender();
        while (end > System.nanoTime()) {
            long delay;
            long start = System.nanoTime();
            try (DocumentContext dc = appender.writingDocument();){
                BenchmarkMain.writeMessage(dc.wire(), messageSize);
            }
            long written = System.nanoTime();
            long time = written - start;
            writeTime.sample(time);
            long diff = writeTime.totalCount() - readTime.totalCount();
            if (diff > 2L) {
                System.out.println("diff=" + diff);
                StringBuilder sb = new StringBuilder();
                sb.append("Reader: profile of the thread");
                Jvm.trimStackTrace(sb, reader.getStackTrace());
                System.out.println(sb);
            }
            if ((delay = (next = (long)((double)next + (double)messageSize * 1.0E9 / ((double)throughput * 1000000.0))) - System.nanoTime()) <= 0L) continue;
            LockSupport.parkNanos(delay);
        }
        while (readTime.totalCount() < writeTime.totalCount()) {
            Jvm.pause(50L);
        }
        pretoucher.interrupt();
        reader.interrupt();
        System.out.println("messageSize " + messageSize);
        System.out.println("messages " + writeTime.totalCount());
        System.out.println("write histogram: " + writeTime.toMicrosFormat());
        System.out.println("transport histogram: " + transportTime.toMicrosFormat());
        System.out.println("read histogram: " + readTime.toMicrosFormat());
        IOTools.deleteDirWithFiles(path, 2);
        Jvm.pause(1000L);
    }

    @NotNull
    private static SingleChronicleQueue createQueue(String path) {
        return ((SingleChronicleQueueBuilder)ChronicleQueueBuilder.single(path).blockSize(0x40000000)).build();
    }

    private static long readMessage(Bytes<?> bytes) {
        Jvm.safepoint();
        long start = bytes.readLong();
        long rp = bytes.readPosition();
        long rl = bytes.readLimit();
        long addr = bytes.addressForRead(rp);
        long addrEnd = bytes.addressForRead(rl);
        Memory memory = OS.memory();
        addr += 8L;
        while (addr + 7L < addrEnd) {
            memory.readLong(addr);
            addr += 8L;
        }
        Jvm.safepoint();
        return start;
    }

    private static void writeMessage(Wire wire, int messageSize) {
        Bytes<?> bytes = wire.bytes();
        long wp = bytes.writePosition();
        long addr = bytes.addressForWrite(wp);
        Memory memory = OS.memory();
        for (int i = 0; i < messageSize; i += 16) {
            memory.writeLong(addr + (long)i, 0L);
            memory.writeLong(addr + (long)i + 8L, 0L);
        }
        bytes.writeSkip(messageSize);
        bytes.writeLong(wp, System.nanoTime());
    }
}

