/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirectoryUtils.class);
    private static final AtomicLong TIMESTAMPER = new AtomicLong(System.currentTimeMillis());

    @NotNull
    public static File tempDir(String name) {
        File tmpDir = new File(OS.TARGET, name + "-" + Long.toString(TIMESTAMPER.getAndIncrement(), 36));
        DeleteStatic.INSTANCE.add(tmpDir);
        if (OS.isMacOSX()) {
            LOGGER.info("Tmp dir: {}", (Object)tmpDir);
        }
        return tmpDir;
    }

    public static void deleteDir(@NotNull File dir) {
        File[] files;
        if (dir.isDirectory() && (files = dir.listFiles()) != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    DirectoryUtils.deleteDir(file);
                    continue;
                }
                if (file.delete()) continue;
                LOGGER.warn("... unable to delete {}", (Object)file);
            }
        }
        dir.delete();
    }

    static enum DeleteStatic {
        INSTANCE;

        final Set<File> toDeleteList = Collections.synchronizedSet(new LinkedHashSet());

        private DeleteStatic() {
            Runtime.getRuntime().addShutdownHook(new Thread(() -> this.toDeleteList.forEach(DirectoryUtils::deleteDir)));
        }

        synchronized void add(File path) {
            this.toDeleteList.add(path);
        }
    }
}

