/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import org.junit.Assert;
import org.junit.Test;

public class RollCycleDefaultingTest {
    @Test
    public void correctConfigGetsLoaded() {
        String aClass = RollCycles.HOURLY.getClass().getName();
        String configuredCycle = aClass + ":HOURLY";
        System.setProperty("net.openhft.queue.builder.defaultRollCycle", configuredCycle);
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((String)"test");
        Assert.assertEquals((Object)RollCycles.HOURLY, (Object)builder.rollCycle());
    }

    @Test
    public void customDefinitionGetsLoaded() {
        String configuredCycle = MyRollcycle.class.getName();
        System.setProperty("net.openhft.queue.builder.defaultRollCycle", configuredCycle);
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((String)"test");
        Assert.assertTrue((boolean)(builder.rollCycle() instanceof MyRollcycle));
    }

    @Test
    public void unknownClassDefaultsToDaily() {
        String configuredCycle = "foobarblah";
        System.setProperty("net.openhft.queue.builder.defaultRollCycle", configuredCycle);
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((String)"test");
        Assert.assertEquals((Object)RollCycles.DAILY, (Object)builder.rollCycle());
    }

    @Test
    public void nonRollCycleDefaultsToDaily() {
        String configuredCycle = String.class.getName();
        System.setProperty("net.openhft.queue.builder.defaultRollCycle", configuredCycle);
        SingleChronicleQueueBuilder builder = SingleChronicleQueueBuilder.binary((String)"test");
        Assert.assertEquals((Object)RollCycles.DAILY, (Object)builder.rollCycle());
    }

    public static class MyRollcycle
    implements RollCycle {
        public String format() {
            return null;
        }

        public int length() {
            return 0;
        }

        public int defaultIndexCount() {
            return 0;
        }

        public int defaultIndexSpacing() {
            return 0;
        }

        public int current(TimeProvider time, long epoch) {
            return 0;
        }

        public long toIndex(int cycle, long sequenceNumber) {
            return 0L;
        }

        public long toSequenceNumber(long index) {
            return 0L;
        }

        public int toCycle(long index) {
            return 0;
        }
    }
}

