/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.SCQIndexing;
import net.openhft.chronicle.queue.impl.single.SCQRoll;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.wire.BinaryWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.junit.Assert;
import org.junit.Test;

public class DetectNotReadyEntriesTest {
    @Test
    public void testDeadEntries() throws FileNotFoundException {
        if (OS.isWindows()) {
            return;
        }
        File dir = new File(OS.TARGET, this.getClass().getSimpleName() + "-" + System.nanoTime());
        dir.mkdir();
        MappedBytes bytes = MappedBytes.mappedBytes((File)new File(dir, "19700101.cq4"), (long)65536L);
        BinaryWire wire = new BinaryWire((Bytes)bytes);
        try (DocumentContext dc = wire.writingDocument(true);){
            dc.wire().writeEventName(() -> "header").typePrefix(SingleChronicleQueueStore.class).marshallable(w -> {
                w.write(() -> "wireType").object((Object)WireType.BINARY);
                w.write(() -> "writePosition").int64forBinding(309L);
                w.write(() -> "roll").typedMarshallable((WriteMarshallable)new SCQRoll((RollCycle)RollCycles.DAILY, 0L));
                w.write(() -> "indexing").typedMarshallable((WriteMarshallable)new SCQIndexing(WireType.BINARY, 32768, 32));
                w.write(() -> "lastAcknowledgedIndexReplicated").int64forBinding(0L);
            });
        }
        long pos = wire.bytes().writePosition();
        try (DocumentContext dc = wire.writingDocument(false);){
            dc.wire().write((CharSequence)"test").text("Hello World");
        }
        Assert.assertEquals((long)17L, (long)wire.bytes().readInt(pos));
        wire.bytes().writeInt(pos, Integer.MIN_VALUE);
        Assert.assertEquals((Object)"--- !!meta-data #binary\nheader: !SCQStore {\n  wireType: !WireType BINARY,\n  writePosition: 309,\n  roll: !SCQSRoll {\n    length: !int 86400000,\n    format: yyyyMMdd,\n    epoch: 0\n  },\n  indexing: !SCQSIndexing {\n    indexCount: !int 32768,\n    indexSpacing: 32,\n    index2Index: 0,\n    lastIndex: 0\n  },\n  lastAcknowledgedIndexReplicated: 0\n}\n# position: 288, header: -1 or 0\n--- !!not-ready-data! #binary\n...\n# 17 bytes remaining\n", (Object)Wires.fromSizePrefixedBlobs((Bytes)bytes.readPosition(0L)));
        bytes.release();
        var7_12 = null;
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)dir).testBlockSize().build();){
            queue.acquireAppender().writeText((CharSequence)"Bye for now");
        }
        catch (Throwable throwable) {
            var7_12 = throwable;
            throw throwable;
        }
        try {
            IOTools.shallowDeleteDirWithFiles((String)dir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        SingleChronicleQueueBuilder.init();
    }
}

