/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.IOException;
import net.openhft.affinity.Affinity;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.impl.single.QueueInspector;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueOut;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class QueueInspectorTest {
    private static final String PROPERTY_KEY = "wire.encodeTidInHeader";
    private static String previousValue = null;
    @Rule
    public TemporaryFolder tmpDir = new TemporaryFolder();

    @BeforeClass
    public static void enableFeature() {
        previousValue = System.getProperty(PROPERTY_KEY);
        System.setProperty(PROPERTY_KEY, Boolean.TRUE.toString());
    }

    @AfterClass
    public static void resetFeature() {
        if (previousValue != null) {
            System.setProperty(PROPERTY_KEY, previousValue);
        } else {
            System.clearProperty(PROPERTY_KEY);
        }
    }

    @Test
    public void shouldDetermineWritingProcessIdWhenDocumentIsNotComplete() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.tmpDir.newFolder()).testBlockSize().build();){
            QueueInspector inspector = new QueueInspector(queue);
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((Object)37L, ValueOut::int64);
            try (DocumentContext ctx = appender.writingDocument();){
                ctx.wire().write((CharSequence)"foo").int32(17L);
                int writingThreadId = inspector.getWritingThreadId();
                Assert.assertThat((Object)writingThreadId, (Matcher)CoreMatchers.is((Object)Affinity.getThreadId()));
                Assert.assertThat((Object)QueueInspector.isValidThreadId((int)writingThreadId), (Matcher)CoreMatchers.is((Object)true));
            }
        }
    }

    @Test
    public void shouldIndicateNoProcessIdWhenDocumentIsComplete() throws IOException {
        try (SingleChronicleQueue queue = SingleChronicleQueueBuilder.binary((File)this.tmpDir.newFolder()).testBlockSize().build();){
            QueueInspector inspector = new QueueInspector(queue);
            ExcerptAppender appender = queue.acquireAppender();
            appender.writeDocument((Object)37L, ValueOut::int64);
            try (DocumentContext ctx = appender.writingDocument();){
                ctx.wire().write((CharSequence)"foo").int32(17L);
            }
            int writingThreadId = inspector.getWritingThreadId();
            Assert.assertThat((Object)writingThreadId, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)OS.getProcessId())));
            Assert.assertThat((Object)QueueInspector.isValidThreadId((int)writingThreadId), (Matcher)CoreMatchers.is((Object)false));
        }
    }
}

