/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.IOTools;
import net.openhft.chronicle.core.util.Histogram;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;

public class BenchmarkMain {
    static int throughput = Integer.getInteger("throughput", 250);
    static int runtime = Integer.getInteger("runtime", 300);
    static String basePath = System.getProperty("path", OS.TMP);

    public static void main(String[] args) {
        MappedFile.warmup();
        System.out.println("Warming up");
        BenchmarkMain.benchmark(128);
        System.out.println("Warmed up");
        for (int size = 64; size <= 0x1000000; size *= 4) {
            BenchmarkMain.benchmark(size);
        }
    }

    static void benchmark(int messageSize) {
        Histogram writeTime = new Histogram(32, 7);
        Histogram transportTime = new Histogram(32, 7);
        Histogram readTime = new Histogram(32, 7);
        String path = basePath + "/test-q-" + messageSize;
        Thread pretoucher = new Thread(() -> {
            try (SingleChronicleQueue queue = ChronicleQueueBuilder.single(path).build();){
                ExcerptAppender appender = queue.acquireAppender();
                while (!Thread.currentThread().isInterrupted()) {
                    appender.pretouch();
                    Jvm.pause(100L);
                }
            }
        });
        pretoucher.setDaemon(true);
        pretoucher.start();
        Thread reader = new Thread(() -> {
            try (SingleChronicleQueue queue = ChronicleQueueBuilder.single(path).build();){
                ExcerptTailer tailer = queue.createTailer();
                while (!Thread.currentThread().isInterrupted()) {
                    long transport = System.nanoTime();
                    DocumentContext dc = tailer.readingDocument();
                    Throwable throwable = null;
                    try {
                        if (!dc.isPresent()) continue;
                        Wire wire = dc.wire();
                        Bytes<?> bytes = wire.bytes();
                        long start = BenchmarkMain.readMessage(bytes);
                        long end = System.nanoTime();
                        transportTime.sample(transport - start);
                        readTime.sample(end - transport);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (dc == null) continue;
                        if (throwable != null) {
                            try {
                                dc.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        dc.close();
                    }
                }
            }
        });
        reader.start();
        Jvm.pause(50L);
        long next = System.nanoTime();
        long end = (long)((double)next + (double)runtime * 1.0E9);
        try (SingleChronicleQueue queue = ChronicleQueueBuilder.single(path).build();){
            ExcerptAppender appender = queue.acquireAppender();
            while (end > System.nanoTime()) {
                long start = System.nanoTime();
                try (DocumentContext dc = appender.writingDocument();){
                    BenchmarkMain.writeMessage(dc.wire(), messageSize);
                }
                long written = System.nanoTime();
                writeTime.sample(written - start);
                long delay = (next = (long)((double)next + (double)messageSize * 1.0E9 / ((double)throughput * 1000000.0))) - System.nanoTime();
                if (delay <= 0L) continue;
                LockSupport.parkNanos(delay);
            }
        }
        while (readTime.totalCount() < writeTime.totalCount()) {
            Jvm.pause(50L);
        }
        pretoucher.interrupt();
        reader.interrupt();
        System.out.println("messageSize " + messageSize);
        System.out.println("messages " + writeTime.totalCount());
        System.out.println("write histogram: " + writeTime.toMicrosFormat());
        System.out.println("transport histogram: " + transportTime.toMicrosFormat());
        System.out.println("read histogram: " + readTime.toMicrosFormat());
        IOTools.deleteDirWithFiles(path, 2);
        Jvm.pause(1000L);
    }

    private static long readMessage(Bytes<?> bytes) {
        long start = bytes.readLong();
        while (bytes.readRemaining() > 7L) {
            bytes.readLong();
        }
        return start;
    }

    private static void writeMessage(Wire wire, int messageSize) {
        Bytes<?> bytes = wire.bytes();
        long wp = bytes.writePosition();
        for (int i = 0; i < messageSize; i += 8) {
            bytes.writeLong(0L);
        }
        bytes.writeLong(wp, System.nanoTime());
    }
}

