/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core;

import java.lang.ref.WeakReference;
import java.util.List;
import net.openhft.chronicle.core.io.Closeable;
import org.jetbrains.annotations.NotNull;
import org.slf4j.LoggerFactory;

public interface ReferenceCounted {
    public static void releaseAll(@NotNull List<WeakReference<ReferenceCounted>> refCounts) {
        for (WeakReference<ReferenceCounted> refCountRef : refCounts) {
            ReferenceCounted refCounted;
            if (refCountRef == null || (refCounted = (ReferenceCounted)refCountRef.get()) == null) continue;
            try {
                refCounted.release();
            }
            catch (IllegalStateException e) {
                LoggerFactory.getLogger(Closeable.class).debug("", e);
            }
        }
    }

    public static void release(Object o) {
        if (o instanceof ReferenceCounted) {
            ReferenceCounted rc = (ReferenceCounted)o;
            try {
                rc.release();
            }
            catch (IllegalStateException e) {
                LoggerFactory.getLogger(Closeable.class).debug("", e);
            }
        }
    }

    public void reserve() throws IllegalStateException;

    public void release() throws IllegalStateException;

    public long refCount();

    default public boolean tryReserve() {
        try {
            if (this.refCount() > 0L) {
                this.reserve();
                return true;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return false;
    }
}

