/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.work.in.progress;

import net.openhft.chronicle.bytes.IORuntimeException;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueue;
import net.openhft.chronicle.wire.BinaryLongArrayReference;
import net.openhft.chronicle.wire.ByteableLongArrayValues;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.TextLongArrayReference;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class Indexer {
    static final long UNINITIALISED = 0L;
    public static final long NUMBER_OF_ENTRIES_IN_EACH_INDEX = 131072L;
    private final AbstractChronicleQueue chronicle;
    private ThreadLocal<ByteableLongArrayValues> array;

    public Indexer(@NotNull ChronicleQueue chronicle, WireType wireType) {
        this.chronicle = (AbstractChronicleQueue)chronicle;
        this.array = Indexer.newLongArrayValuesPool(wireType);
    }

    public static ThreadLocal<ByteableLongArrayValues> newLongArrayValuesPool(WireType wireType) {
        if (wireType == WireType.TEXT) {
            return ThreadLocal.withInitial(TextLongArrayReference::new);
        }
        if (wireType == WireType.BINARY) {
            return ThreadLocal.withInitial(BinaryLongArrayReference::new);
        }
        throw new IllegalStateException("todo, unsupported type=" + wireType);
    }

    public synchronized void index() throws Exception {
        ExcerptTailer tailer = this.chronicle.createTailer();
        long i = 0L;
        while (i <= this.chronicle.lastWrittenIndex()) {
            long index = i++;
            tailer.readDocument(wireIn -> {
                long address = wireIn.bytes().readPosition() - 4L;
                this.recordAddress(index, address);
                wireIn.bytes().readSkip(wireIn.bytes().readRemaining());
            });
        }
    }

    private void recordAddress(final long index, final long address) {
        if (index % 64L != 0L) {
            return;
        }
        final LongArrayValues array = (LongArrayValues)this.array.get();
        long index2Index = this.chronicle.indexToIndex();
        this.chronicle.wire().readDocument(index2Index, rootIndex -> {
            rootIndex.read(() -> "index").int64array(array, (Object)this, (o, o2) -> {});
            long secondaryAddress = array.getValueAt(IndexOffset.toAddress0(index));
            if (secondaryAddress == 0L) {
                secondaryAddress = this.chronicle.newIndex();
                array.setValueAt(index, secondaryAddress);
            }
            this.chronicle.wire().readDocument(secondaryAddress, new ReadMarshallable(){

                public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
                    wire.read(() -> "index").int64array(array, (Object)this, (o, o2) -> {});
                    array.setValueAt(IndexOffset.toAddress1(index), address);
                }
            }, null);
        }, null);
    }

    public static enum IndexOffset {


        public static long toAddress0(long index) {
            long siftedIndex = index >> 23;
            long mask = 131071L;
            long maskedShiftedIndex = mask & siftedIndex;
            return maskedShiftedIndex * 8L;
        }

        public static long toAddress1(long index) {
            long siftedIndex = index >> 6;
            long mask = 131071L;
            long maskedShiftedIndex = mask & siftedIndex;
            return maskedShiftedIndex * 8L;
        }

        @NotNull
        public static String toBinaryString(long i) {
            StringBuilder sb = new StringBuilder();
            for (int n = 63; n >= 0; --n) {
                sb.append((i & 1L << n) != 0L ? "1" : "0");
            }
            return sb.toString();
        }

        @NotNull
        public static String toScale() {
            int n;
            StringBuilder units = new StringBuilder();
            StringBuilder tens = new StringBuilder();
            for (n = 64; n >= 1; --n) {
                units.append(0 == n % 10 ? "|" : Integer.valueOf(n % 10));
            }
            for (n = 64; n >= 1; --n) {
                tens.append(0 == n % 10 ? Integer.valueOf(n / 10) : " ");
            }
            return units.toString() + "\n" + tens.toString();
        }
    }
}

