/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class WirePool {
    private final ThreadLocal<Wire> readPool;
    private final ThreadLocal<Wire> writePool;
    private final BytesStore bytesStore;
    private final Function<Bytes, Wire> wireSupplier;

    public WirePool(@NotNull BytesStore bytesStore, @NotNull Function<Bytes, Wire> wireSupplier) {
        this.bytesStore = bytesStore;
        this.wireSupplier = wireSupplier;
        this.readPool = new ThreadLocal();
        this.writePool = new ThreadLocal();
    }

    @ForceInline
    public WireIn acquireForReadAt(long position) {
        Wire wire = this.readPool.get();
        if (wire == null) {
            wire = this.wireSupplier.apply(this.bytesStore.bytesForRead());
            this.readPool.set(wire);
        }
        wire.bytes().readPosition(position);
        return wire;
    }

    @ForceInline
    public WireOut acquireForWriteAt(long position) {
        Wire wire = this.writePool.get();
        if (wire == null) {
            wire = this.wireSupplier.apply(this.bytesStore.bytesForWrite());
            this.writePool.set(wire);
        }
        wire.bytes().writePosition(position);
        return wire;
    }
}

