/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.IOException;
import java.util.function.ToLongFunction;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class Excerpts {

    static class Tailer
    implements ExcerptTailer {
        private final AbstractChronicleQueue queue;
        private long cycle;
        private long index;
        private long position;
        private WireStore store;
        private boolean toStart;

        Tailer(@NotNull AbstractChronicleQueue queue) throws IOException {
            this.queue = queue;
            this.cycle = -1L;
            this.index = -1L;
            this.store = null;
            this.position = 0L;
            this.toStart = false;
        }

        @Override
        public boolean readDocument(ReadMarshallable reader) throws IOException {
            long position;
            if (this.store == null) {
                long lastCycle;
                long l = lastCycle = this.toStart ? this.queue.firstCycle() : this.queue.lastCycle();
                if (lastCycle == -1L) {
                    return false;
                }
                this.cycle(lastCycle, WireStore::readPosition);
            }
            if ((position = this.store.read(this.position, reader)) > 0L) {
                this.position = position;
                ++this.index;
                return true;
            }
            if (position < 0L) {
                this.cycle(Math.abs(position), WireStore::readPosition);
                return this.readDocument(reader);
            }
            return false;
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public long cycle() {
            if (this.store == null) {
                throw new IllegalArgumentException("This tailer is not bound to any cycle");
            }
            return this.store.cycle();
        }

        @Override
        public boolean index(long index) throws IOException {
            long idxpos;
            if (this.store == null) {
                this.cycle(this.queue.lastCycle(), WireStore::readPosition);
            }
            if ((idxpos = this.store.positionForIndex(index)) != -1L) {
                this.position = idxpos;
                this.index = index - 1L;
                return true;
            }
            return false;
        }

        @Override
        public boolean index(long cycle, long index) throws IOException {
            this.cycle(cycle, WireStore::readPosition);
            return this.index(index);
        }

        @Override
        public ExcerptTailer toStart() throws IOException {
            long cycle = this.queue.firstCycle();
            if (cycle > 0L) {
                this.cycle(cycle, WireStore::readPosition);
                this.toStart = false;
            } else {
                this.toStart = true;
            }
            return this;
        }

        @Override
        public ExcerptTailer toEnd() throws IOException {
            long cycle = this.queue.firstCycle();
            if (cycle > 0L) {
                this.cycle(cycle, WireStore::writePosition);
            }
            this.toStart = false;
            return this;
        }

        @Override
        public ChronicleQueue queue() {
            return this.queue;
        }

        private void cycle(long cycle, @NotNull ToLongFunction<WireStore> positionSupplier) throws IOException {
            if (this.cycle != cycle) {
                if (null != this.store) {
                    this.queue.release(this.store);
                }
                this.cycle = cycle;
                this.index = -1L;
                this.store = this.queue.storeForCycle(this.cycle);
                this.position = positionSupplier.applyAsLong(this.store);
            }
        }
    }

    static class Appender
    implements ExcerptAppender {
        private final AbstractChronicleQueue queue;
        private long cycle;
        private long index;
        private WireStore store;

        Appender(@NotNull AbstractChronicleQueue queue) throws IOException {
            this.queue = queue;
            this.cycle = queue.lastCycle();
            this.store = this.cycle > 0L ? queue.storeForCycle(this.cycle) : null;
            this.index = this.cycle > 0L ? this.store.lastIndex() : -1L;
        }

        @Override
        public long writeDocument(WriteMarshallable writer) throws IOException {
            if (this.cycle != this.queue.cycle()) {
                long nextCycle = this.queue.cycle();
                if (this.store != null) {
                    this.store.appendRollMeta(nextCycle);
                    this.queue.release(this.store);
                }
                this.cycle = nextCycle;
                this.store = this.queue.storeForCycle(this.cycle);
            }
            this.index = this.store.append(writer);
            return this.index;
        }

        @Override
        public long index() {
            if (this.index == -1L) {
                throw new IllegalStateException();
            }
            return this.index;
        }

        @Override
        public long cycle() {
            return this.store.cycle();
        }

        @Override
        public ChronicleQueue queue() {
            return this.queue;
        }
    }
}

