/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.time.ZoneId;
import java.util.Objects;
import net.openhft.chronicle.queue.RollCycles;

public interface RollCycle {
    public static RollCycle forLength(int length) {
        for (int i = RollCycles.VALUES.length - 1; i >= 0; --i) {
            if (RollCycles.VALUES[i].length != length) continue;
            return RollCycles.VALUES[i];
        }
        throw new IllegalArgumentException("Unknown value for CycleLength (" + length + ")");
    }

    public static RollCycle forFormat(String format) {
        for (int i = RollCycles.VALUES.length - 1; i >= 0; --i) {
            if (!Objects.equals(RollCycles.VALUES[i].format, format) && !RollCycles.VALUES[i].format.equals(format)) continue;
            return RollCycles.VALUES[i];
        }
        throw new IllegalArgumentException("Unknown value for CycleFormat (" + format + ")");
    }

    public static RollCycle from(final int length, final String format, final ZoneId zone) {
        return new RollCycle(){

            @Override
            public String format() {
                return format;
            }

            @Override
            public int length() {
                return length;
            }

            @Override
            public ZoneId zone() {
                return zone;
            }
        };
    }

    public String format();

    public int length();

    public ZoneId zone();

    default public int current() {
        return (int)(System.currentTimeMillis() / (long)this.length());
    }
}

