/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.slf4j;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.logger.ChronicleLogManager;
import net.openhft.chronicle.logger.ChronicleLogWriter;
import net.openhft.chronicle.logger.slf4j.ChronicleLogger;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;
import org.slf4j.impl.SimpleLogger;

public class ChronicleLoggerFactory
implements ILoggerFactory {
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private final ChronicleLogManager manager = ChronicleLogManager.getInstance();

    public Logger getLogger(String name) {
        try {
            return this.doGetLogger(name);
        }
        catch (Exception e) {
            System.err.println("Unable to initialize chronicle-logger-slf4j (" + name + ")\n  " + e.getMessage());
            e.printStackTrace();
            return NOPLogger.NOP_LOGGER;
        }
    }

    synchronized void reload() {
        this.loggers.clear();
        this.manager.reload();
    }

    private synchronized Logger doGetLogger(String name) {
        Object logger = this.loggers.get(name);
        if (logger == null) {
            if (name != null && name.startsWith("net.openhft")) {
                SimpleLogger.lazyInit();
                logger = new SimpleLogger(name);
            } else {
                ChronicleLogWriter writer = this.manager.getWriter(name);
                logger = new ChronicleLogger(writer, name, this.manager.cfg().getLevel(name));
            }
            this.loggers.put(name, (Logger)logger);
        }
        return logger;
    }
}

