/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.slf4j;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import net.openhft.chronicle.logger.IndexedLogAppenderConfig;
import net.openhft.chronicle.logger.VanillaLogAppenderConfig;

public class ChronicleLoggingConfig {
    public static final String KEY_PROPERTIES_FILE = "slf4j.chronicle.properties";
    public static final String KEY_PREFIX = "slf4j.chronicle.";
    public static final String KEY_CFG_PREFIX = "slf4j.chronicle.cfg.";
    public static final String KEY_CHRONICLE_TYPE = "slf4j.chronicle.type";
    public static final String KEY_LOGER = "logger";
    public static final String KEY_LEVEL = "level";
    public static final String KEY_PATH = "path";
    public static final String KEY_SHORTNAME = "shortName";
    public static final String KEY_APPEND = "append";
    public static final String KEY_FORMAT = "format";
    public static final String KEY_TYPE = "type";
    public static final String KEY_DATE_FORMAT = "dateFormat";
    public static final String KEY_BINARY_MODE = "binaryMode";
    public static final String KEY_STACK_TRACE_DEPTH = "stackTraceDepth";
    public static final String FORMAT_BINARY = "binary";
    public static final String FORMAT_TEXT = "text";
    public static final String TYPE_VANILLA = "vanilla";
    public static final String TYPE_INDEXED = "indexed";
    public static final String BINARY_MODE_FORMATTED = "formatted";
    public static final String BINARY_MODE_SERIALIZED = "serialized";
    public static final String PLACEHOLDER_START = "${";
    public static final String PLACEHOLDER_END = "}";
    public static final String PLACEHOLDER_TODAY = "${today}";
    public static final String PLACEHOLDER_TODAY_FORMAT = "yyyyMMdd";
    public static final String PLACEHOLDER_PID = "${pid}";
    public static final String DEFAULT_DATE_FORMAT = "yyyy.MM.dd-HH:mm:ss.SSS";
    private static final DateFormat DATEFORMAT = new SimpleDateFormat("yyyyMMdd");
    private static final String PID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    private final Properties properties;
    private final IndexedLogAppenderConfig indexedConfig;
    private final VanillaLogAppenderConfig vanillaConfig;

    private ChronicleLoggingConfig(Properties properties, IndexedLogAppenderConfig indexedConfig, VanillaLogAppenderConfig vanillaConfig) {
        this.properties = properties;
        this.indexedConfig = indexedConfig;
        this.vanillaConfig = vanillaConfig;
    }

    public static ChronicleLoggingConfig load(Properties properties) {
        return new ChronicleLoggingConfig(properties, ChronicleLoggingConfig.loadIndexedConfig(properties), ChronicleLoggingConfig.loadVanillaConfig(properties));
    }

    public static ChronicleLoggingConfig load(String cfgPath) {
        Properties properties = new Properties();
        try {
            FileInputStream in = new FileInputStream(cfgPath);
            try {
                properties.load(in);
                ((InputStream)in).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ChronicleLoggingConfig.interpolate(properties);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
        return ChronicleLoggingConfig.load(properties);
    }

    public static ChronicleLoggingConfig load() {
        String cfgPath = System.getProperty(KEY_PROPERTIES_FILE);
        if (cfgPath == null) {
            System.err.printf("Unable to configure chroncile-slf4j, property %s is not defined\n", KEY_PROPERTIES_FILE);
            return null;
        }
        return ChronicleLoggingConfig.load(cfgPath);
    }

    private static Properties interpolate(Properties tmpProperties) {
        int amended = 0;
        do {
            amended = 0;
            for (Map.Entry<Object, Object> entries : tmpProperties.entrySet()) {
                String val = tmpProperties.getProperty((String)entries.getKey());
                val = val.replace(PLACEHOLDER_TODAY, DATEFORMAT.format(new Date()));
                val = val.replace(PLACEHOLDER_PID, PID);
                int startIndex = 0;
                int endIndex = 0;
                do {
                    if ((startIndex = val.indexOf(PLACEHOLDER_START, endIndex)) == -1 || (endIndex = val.indexOf(PLACEHOLDER_END, startIndex)) == -1) continue;
                    String envKey = val.substring(startIndex + 2, endIndex);
                    String newVal = null;
                    if (tmpProperties.containsKey(envKey)) {
                        newVal = tmpProperties.getProperty(envKey);
                    } else if (System.getProperties().containsKey(envKey)) {
                        newVal = System.getProperties().getProperty(envKey);
                    }
                    if (newVal == null) continue;
                    val = val.replace(PLACEHOLDER_START + envKey + PLACEHOLDER_END, newVal);
                    endIndex += newVal.length() - envKey.length() + 3;
                    ++amended;
                } while (startIndex != -1 && endIndex != -1 && endIndex < val.length());
                entries.setValue(val);
            }
        } while (amended > 0);
        return tmpProperties;
    }

    private static IndexedLogAppenderConfig loadIndexedConfig(Properties properties) {
        if (!TYPE_INDEXED.equalsIgnoreCase(properties.getProperty(KEY_CHRONICLE_TYPE))) {
            return null;
        }
        IndexedLogAppenderConfig cfg = new IndexedLogAppenderConfig();
        cfg.setProperties(properties, KEY_CFG_PREFIX);
        return cfg;
    }

    private static VanillaLogAppenderConfig loadVanillaConfig(Properties properties) {
        if (!TYPE_VANILLA.equalsIgnoreCase(properties.getProperty(KEY_CHRONICLE_TYPE))) {
            return null;
        }
        VanillaLogAppenderConfig cfg = new VanillaLogAppenderConfig();
        cfg.setProperties(properties, KEY_CFG_PREFIX);
        return cfg;
    }

    public IndexedLogAppenderConfig getIndexedChronicleConfig() {
        return this.indexedConfig;
    }

    public VanillaLogAppenderConfig getVanillaChronicleConfig() {
        return this.vanillaConfig;
    }

    public String getString(String shortName) {
        String name = KEY_PREFIX + shortName;
        return this.properties.getProperty(name);
    }

    public String getString(String loggerName, String shortName) {
        String key = "slf4j.chronicle.logger." + loggerName + "." + shortName;
        String val = this.properties.getProperty(key);
        if (val == null) {
            val = this.getString(shortName);
        }
        return val;
    }

    public Boolean getBoolean(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Boolean.valueOf("true".equalsIgnoreCase(prop)) : null;
    }

    public Boolean getBoolean(String shortName, boolean defval) {
        String prop = this.getString(shortName);
        return prop != null ? "true".equalsIgnoreCase(prop) : defval;
    }

    public Boolean getBoolean(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Boolean.valueOf("true".equalsIgnoreCase(prop)) : null;
    }

    public Boolean getBoolean(String loggerName, String shortName, boolean defval) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? "true".equalsIgnoreCase(prop) : defval;
    }

    public Integer getInteger(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Integer.valueOf(Integer.parseInt(prop)) : null;
    }

    public Integer getInteger(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Integer.valueOf(Integer.parseInt(prop)) : null;
    }

    public Long getLong(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Long.valueOf(Long.parseLong(prop)) : null;
    }

    public Long getLong(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Long.valueOf(Long.parseLong(prop)) : null;
    }

    public Double getDouble(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Double.valueOf(Double.parseDouble(prop)) : null;
    }

    public Double getDouble(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Double.valueOf(Double.parseDouble(prop)) : null;
    }

    public Short getShort(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Short.valueOf(Short.parseShort(prop)) : null;
    }

    public Short getShort(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Short.valueOf(Short.parseShort(prop)) : null;
    }
}

