/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.slf4j;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ChronicleConfig;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.VanillaChronicleConfig;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.slf4j.ChronicleLogAppender;
import net.openhft.chronicle.logger.slf4j.ChronicleLogAppenders;
import net.openhft.chronicle.logger.slf4j.ChronicleLogger;
import net.openhft.chronicle.logger.slf4j.ChronicleLoggingConfig;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.helpers.NOPLogger;

public class ChronicleLoggerFactory
implements ILoggerFactory {
    private final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
    private final Map<String, ChronicleLogAppender> appenders = new ConcurrentHashMap<String, ChronicleLogAppender>();
    private ChronicleLoggingConfig cfg = ChronicleLoggingConfig.load();

    public ChronicleLoggerFactory() {
        this(ChronicleLoggingConfig.load());
    }

    public ChronicleLoggerFactory(ChronicleLoggingConfig cfg) {
    }

    public Logger getLogger(String name) {
        try {
            return this.doGetLogger(name);
        }
        catch (Exception e) {
            System.err.println("Unable to inzialize chroncile-slf4j " + "(" + name + ")" + "\n  " + e.getMessage());
            return NOPLogger.NOP_LOGGER;
        }
    }

    public synchronized void warmup() {
    }

    public synchronized void shutdown() {
        for (ChronicleLogAppender appender : this.appenders.values()) {
            try {
                appender.getChronicle().close();
            }
            catch (IOException e) {
                System.err.println(e.getMessage());
            }
        }
        this.loggers.clear();
        this.appenders.clear();
    }

    public synchronized void relaod() {
        this.shutdown();
        this.cfg = ChronicleLoggingConfig.load();
    }

    private synchronized Logger doGetLogger(String name) throws Exception {
        if (this.cfg == null) {
            throw new IllegalArgumentException("chronicle-slf4j is not configured");
        }
        Object logger = this.loggers.get(name);
        if (logger == null) {
            String path = this.cfg.getString(name, "path");
            String level = this.cfg.getString(name, "level");
            if (path != null) {
                logger = new ChronicleLogger(this.newAppender(path, name), name, ChronicleLogLevel.fromStringLevel((CharSequence)level));
                this.loggers.put(name, (Logger)logger);
            } else if (path == null) {
                throw new IllegalArgumentException("slf4j.chronicle.path is not defined" + "," + "slf4j.chronicle.logger." + name + ".path is not defined");
            }
        }
        return logger;
    }

    private ChronicleLogAppender newAppender(String path, String name) throws Exception {
        ChronicleLogAppender appender = this.appenders.get(path);
        if (appender == null) {
            String type = this.cfg.getString(name, "type");
            String format = this.cfg.getString(name, "format");
            String binaryMode = this.cfg.getString("binaryMode");
            Integer stDepth = this.cfg.getInteger("stackTraceDepth");
            if ("binary".equalsIgnoreCase(format)) {
                Chronicle chronicle = this.newChronicle(type, path, name);
                appender = "serialized".equalsIgnoreCase(binaryMode) ? new ChronicleLogAppenders.BinaryWriter(chronicle) : new ChronicleLogAppenders.BinaryFormattingWriter(chronicle);
            } else if ("text".equalsIgnoreCase(format)) {
                appender = new ChronicleLogAppenders.TextWriter(this.newChronicle(type, path, name), null, stDepth);
            }
            if (appender != null && appender.getChronicle() instanceof IndexedChronicle) {
                appender = new ChronicleLogAppenders.SynchronizedWriter(appender);
            }
            this.appenders.put(path, appender);
        }
        return appender;
    }

    private Chronicle newChronicle(String type, String path, String name) throws Exception {
        if ("indexed".equalsIgnoreCase(type)) {
            return this.newIndexedChronicle(path, name);
        }
        if ("vanilla".equalsIgnoreCase(type)) {
            return this.newVanillaChronicle(path, name);
        }
        throw new IllegalArgumentException("type should be indexed or vanilla");
    }

    private Chronicle newVanillaChronicle(String path, String name) throws IOException {
        Boolean append = this.cfg.getBoolean(name, "append", true);
        Boolean synch = this.cfg.getBoolean(name, "synchronous", false);
        VanillaChronicle chronicle = new VanillaChronicle(path, new VanillaChronicleConfig().synchronous(synch.booleanValue()));
        if (!append.booleanValue()) {
            chronicle.clear();
        }
        return chronicle;
    }

    private Chronicle newIndexedChronicle(String path, String name) throws IOException {
        Boolean append = this.cfg.getBoolean(name, "append", true);
        Boolean synch = this.cfg.getBoolean(name, "synchronous", false);
        if (!append.booleanValue()) {
            new File(path + ".data").delete();
            new File(path + ".index").delete();
        }
        return new IndexedChronicle(path, ChronicleConfig.DEFAULT.clone().synchronousMode(synch.booleanValue()));
    }
}

