/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.slf4j;

import java.io.Closeable;
import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.VanillaChronicle;
import net.openhft.chronicle.logger.ChronicleLog;
import net.openhft.chronicle.logger.ChronicleLogHelper;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.TimeStampFormatter;
import net.openhft.chronicle.logger.slf4j.ChronicleLogAppender;
import net.openhft.lang.io.ByteStringAppender;
import net.openhft.lang.io.RandomDataOutput;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;

public class ChronicleLogAppenders {

    public static final class SynchronizedWriter
    implements ChronicleLogAppender,
    Closeable {
        private final ChronicleLogAppender writer;
        private final Object sync;

        public SynchronizedWriter(ChronicleLogAppender writer) {
            this.writer = writer;
            this.sync = new Object();
        }

        @Override
        public Chronicle getChronicle() {
            return this.writer.getChronicle();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object arg1) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.log(level, name, message, arg1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object arg1, Object arg2) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.log(level, name, message, arg1, arg2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object ... args) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.log(level, name, message, args);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void log(ChronicleLogLevel level, String name, String message, Throwable throwable) {
            Object object = this.sync;
            synchronized (object) {
                this.writer.log(level, name, message, throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Object object = this.sync;
            synchronized (object) {
                this.writer.close();
            }
        }
    }

    public static final class TextWriter
    extends AbstractChronicleLogWriter {
        private final TimeStampFormatter timeStampFormatter;
        private final int stackTraceDepth;

        public TextWriter(Chronicle chronicle, String dateFormat, Integer stackTraceDepth) throws IOException {
            super(chronicle);
            this.stackTraceDepth = stackTraceDepth != null ? stackTraceDepth : -1;
            this.timeStampFormatter = TimeStampFormatter.fromDateFormat((String)(dateFormat != null ? dateFormat : "yyyy.MM.dd-HH:mm:ss.SSS"));
        }

        private Throwable logCommon(ExcerptAppender appender, ChronicleLogLevel level, String name, FormattingTuple tp) {
            this.timeStampFormatter.format(System.currentTimeMillis(), (ByteStringAppender)appender);
            appender.append('|');
            level.printTo((ByteStringAppender)appender);
            appender.append('|');
            appender.append((CharSequence)Thread.currentThread().getName());
            appender.append('|');
            appender.append((CharSequence)name);
            appender.append('|');
            appender.append((CharSequence)tp.getMessage());
            return tp.getThrowable();
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object arg1) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                FormattingTuple ft = MessageFormatter.format((String)message, (Object)arg1);
                Throwable thw = this.logCommon(appender, level, name, ft);
                if (thw != null) {
                    appender.append((CharSequence)" - ");
                    ChronicleLogHelper.appendStackTraceAsString((ExcerptAppender)appender, (Throwable)thw, (String)", ", (int)this.stackTraceDepth);
                }
                appender.append('\n');
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object arg1, Object arg2) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                FormattingTuple ft = MessageFormatter.format((String)message, (Object)arg1, (Object)arg2);
                Throwable thw = this.logCommon(appender, level, name, ft);
                if (thw != null) {
                    appender.append((CharSequence)" - ");
                    ChronicleLogHelper.appendStackTraceAsString((ExcerptAppender)appender, (Throwable)thw, (String)", ", (int)this.stackTraceDepth);
                }
                appender.append('\n');
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object ... args) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                FormattingTuple ft = MessageFormatter.arrayFormat((String)message, (Object[])args);
                Throwable thw = this.logCommon(appender, level, name, ft);
                if (thw != null) {
                    appender.append((CharSequence)" - ");
                    ChronicleLogHelper.appendStackTraceAsString((ExcerptAppender)appender, (Throwable)thw, (String)", ", (int)this.stackTraceDepth);
                }
                appender.append('\n');
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Throwable throwable) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                FormattingTuple ft = MessageFormatter.format((String)message, (Object)throwable);
                Throwable thw = this.logCommon(appender, level, name, ft);
                if (thw != null) {
                    appender.append((CharSequence)" - ");
                    ChronicleLogHelper.appendStackTraceAsString((ExcerptAppender)appender, (Throwable)thw, (String)", ", (int)this.stackTraceDepth);
                }
                appender.append('\n');
                appender.finish();
            }
        }
    }

    public static final class BinaryFormattingWriter
    extends AbstractChronicleLogWriter {
        public BinaryFormattingWriter(Chronicle chronicle) throws IOException {
            super(chronicle);
        }

        private Throwable logCommon(ExcerptAppender appender, ChronicleLogLevel level, String name, FormattingTuple tp) {
            appender.writeByte(1);
            ChronicleLog.Type.SLF4J.writeTo((RandomDataOutput)appender);
            appender.writeLong(System.currentTimeMillis());
            level.writeTo((RandomDataOutput)appender);
            appender.writeUTF(Thread.currentThread().getName());
            appender.writeUTF(name);
            appender.writeUTF(tp.getMessage());
            appender.writeStopBit(0L);
            return tp.getThrowable();
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object arg1) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                FormattingTuple ft = MessageFormatter.format((String)message, (Object)arg1);
                Throwable thw = this.logCommon(appender, level, name, ft);
                if (thw == null) {
                    appender.writeBoolean(false);
                } else {
                    appender.writeBoolean(true);
                    appender.writeObject((Object)thw);
                }
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object arg1, Object arg2) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                FormattingTuple ft = MessageFormatter.format((String)message, (Object)arg1, (Object)arg2);
                Throwable thw = this.logCommon(appender, level, name, ft);
                if (thw == null) {
                    appender.writeBoolean(false);
                } else {
                    appender.writeBoolean(true);
                    appender.writeObject((Object)thw);
                }
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object ... args) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                FormattingTuple ft = MessageFormatter.arrayFormat((String)message, (Object[])args);
                Throwable thw = this.logCommon(appender, level, name, ft);
                if (thw == null) {
                    appender.writeBoolean(false);
                } else {
                    appender.writeBoolean(true);
                    appender.writeObject((Object)thw);
                }
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Throwable throwable) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                FormattingTuple ft = MessageFormatter.format((String)message, (Object)throwable);
                Throwable thw = this.logCommon(appender, level, name, ft);
                if (thw == null) {
                    appender.writeBoolean(false);
                } else {
                    appender.writeBoolean(true);
                    appender.writeObject((Object)thw);
                }
                appender.finish();
            }
        }
    }

    public static final class BinaryWriter
    extends AbstractChronicleLogWriter {
        public BinaryWriter(Chronicle chronicle) throws IOException {
            super(chronicle);
        }

        private void logCommon(ExcerptAppender appender, ChronicleLogLevel level, String name, String message) {
            appender.writeByte(1);
            ChronicleLog.Type.SLF4J.writeTo((RandomDataOutput)appender);
            appender.writeLong(System.currentTimeMillis());
            level.writeTo((RandomDataOutput)appender);
            appender.writeUTF(Thread.currentThread().getName());
            appender.writeUTF(name);
            appender.writeUTF(message);
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object arg1) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, name, message);
                if (!(arg1 instanceof Throwable)) {
                    appender.writeStopBit(1L);
                    appender.writeObject(arg1);
                    appender.writeBoolean(false);
                } else {
                    appender.writeStopBit(0L);
                    appender.writeBoolean(true);
                    appender.writeObject(arg1);
                }
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object arg1, Object arg2) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, name, message);
                if (!(arg2 instanceof Throwable)) {
                    appender.writeStopBit(2L);
                    appender.writeObject(arg1);
                    appender.writeObject(arg2);
                    appender.writeBoolean(false);
                } else {
                    appender.writeStopBit(1L);
                    appender.writeObject(arg1);
                    appender.writeBoolean(true);
                    appender.writeObject(arg2);
                }
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Object ... args) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, name, message);
                if (args.length > 0 && args[args.length - 1] instanceof Throwable) {
                    appender.writeStopBit((long)(args.length - 1));
                    for (int i = 0; i < args.length - 1; ++i) {
                        appender.writeObject(args[i]);
                    }
                    appender.writeBoolean(true);
                    appender.writeObject(args[args.length - 1]);
                } else {
                    appender.writeStopBit((long)args.length);
                    for (Object arg : args) {
                        appender.writeObject(arg);
                    }
                    appender.writeBoolean(false);
                }
                appender.finish();
            }
        }

        @Override
        public void log(ChronicleLogLevel level, String name, String message, Throwable throwable) {
            ExcerptAppender appender = this.getAppender();
            if (appender != null) {
                appender.startExcerpt();
                this.logCommon(appender, level, name, message);
                appender.writeStopBit(0L);
                appender.writeBoolean(true);
                appender.writeObject((Object)throwable);
                appender.finish();
            }
        }
    }

    private static abstract class AbstractChronicleLogWriter
    implements ChronicleLogAppender {
        protected final ExcerptAppenderProvider appenderProvider;
        private final Chronicle chronicle;

        public AbstractChronicleLogWriter(Chronicle chronicle) throws IOException {
            this.chronicle = chronicle;
            this.appenderProvider = chronicle instanceof VanillaChronicle ? new VanillaExcerptAppenderProvider(chronicle) : new IndexedExcerptAppenderProvider(chronicle);
        }

        @Override
        public Chronicle getChronicle() {
            return this.chronicle;
        }

        public ExcerptAppender getAppender() {
            return this.appenderProvider.get();
        }

        @Override
        public void close() throws IOException {
            if (this.chronicle != null) {
                this.chronicle.close();
            }
        }
    }

    private static class VanillaExcerptAppenderProvider
    implements ExcerptAppenderProvider {
        private final Chronicle chronicle;

        public VanillaExcerptAppenderProvider(Chronicle chronicle) {
            this.chronicle = chronicle;
        }

        @Override
        public ExcerptAppender get() {
            try {
                return this.chronicle.createAppender();
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    private static class IndexedExcerptAppenderProvider
    implements ExcerptAppenderProvider {
        private ExcerptAppender appender;

        public IndexedExcerptAppenderProvider(Chronicle chronicle) {
            try {
                this.appender = chronicle.createAppender();
            }
            catch (IOException e) {
                this.appender = null;
                e.printStackTrace();
            }
        }

        @Override
        public ExcerptAppender get() {
            return this.appender;
        }
    }

    private static interface ExcerptAppenderProvider {
        public ExcerptAppender get();
    }
}

