/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.spi.FilterReply;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.logger.ChronicleLog;
import net.openhft.chronicle.logger.logback.AbstractChronicleAppender;
import net.openhft.lang.io.RandomDataOutput;

public abstract class BinaryChronicleAppender
extends AbstractChronicleAppender {
    private boolean includeCallerData = true;
    private boolean includeMDC = true;
    private boolean formatMessage = false;

    protected BinaryChronicleAppender() {
    }

    public void setIncludeCallerData(boolean logCallerData) {
        this.includeCallerData = logCallerData;
    }

    public boolean isIncludeCallerData() {
        return this.includeCallerData;
    }

    public void setIncludeMappedDiagnosticContext(boolean logMDC) {
        this.includeMDC = logMDC;
    }

    public boolean isIncludeMappedDiagnosticContext() {
        return this.includeMDC;
    }

    public void setFormatMessage(boolean formatMessage) {
        this.formatMessage = formatMessage;
    }

    public boolean isFormatMessage() {
        return this.formatMessage;
    }

    public void doAppend(ILoggingEvent event) {
        ExcerptAppender appender;
        if (this.getFilterChainDecision(event) != FilterReply.DENY && (appender = this.getAppender()) != null) {
            appender.startExcerpt();
            appender.writeByte(1);
            ChronicleLog.Type.LOGBACK.writeTo((RandomDataOutput)appender);
            appender.writeLong(event.getTimeStamp());
            BinaryChronicleAppender.toChronicleLogLevel(event.getLevel()).writeTo((RandomDataOutput)appender);
            appender.writeUTF(event.getThreadName());
            appender.writeUTF(event.getLoggerName());
            if (!this.formatMessage) {
                appender.writeUTF(event.getMessage());
                Object[] args = event.getArgumentArray();
                int argsLen = null != args ? args.length : 0;
                appender.writeStopBit((long)argsLen);
                for (int i = 0; i < argsLen; ++i) {
                    appender.writeObject(args[i]);
                }
            } else {
                appender.writeUTF(event.getFormattedMessage());
                appender.writeStopBit(0L);
            }
            ThrowableProxy tp = (ThrowableProxy)event.getThrowableProxy();
            if (tp != null) {
                appender.writeBoolean(true);
                appender.writeObject((Object)tp.getThrowable());
            } else {
                appender.writeBoolean(false);
            }
            appender.finish();
        }
    }
}

