/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger.log4j2;

import java.io.IOException;
import net.openhft.chronicle.Chronicle;
import net.openhft.chronicle.ExcerptAppender;
import net.openhft.chronicle.IndexedChronicle;
import net.openhft.chronicle.logger.IndexedLogAppenderConfig;
import net.openhft.chronicle.logger.log4j2.AbstractChronicleAppender;
import net.openhft.chronicle.logger.log4j2.BinaryChronicleAppender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="BinaryIndexedChronicle", category="Core", elementType="appender", printObject=true)
public class BinaryIndexedChronicleAppender
extends BinaryChronicleAppender {
    private final IndexedLogAppenderConfig config;
    private final Object lock;
    private ExcerptAppender appender;

    public BinaryIndexedChronicleAppender(String name, Filter filter, String path, IndexedLogAppenderConfig config) {
        super(name, filter, path);
        this.config = config;
        this.appender = null;
        this.lock = new Object();
    }

    @Override
    protected Chronicle createChronicle() throws IOException {
        IndexedChronicle chronicle = this.config != null ? new IndexedChronicle(this.getPath(), this.config.cfg()) : new IndexedChronicle(this.getPath());
        this.appender = chronicle.createAppender();
        return chronicle;
    }

    @Override
    protected ExcerptAppender getAppender() {
        return this.appender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void append(LogEvent event) {
        Object object = this.lock;
        synchronized (object) {
            super.append(event);
        }
    }

    protected IndexedLogAppenderConfig getChronicleConfig() {
        return this.config;
    }

    @PluginFactory
    public static BinaryIndexedChronicleAppender createAppender(@PluginAttribute(value="name") String name, @PluginAttribute(value="path") String path, @PluginAttribute(value="formatMessage") String formatMessage, @PluginAttribute(value="includeCallerData") String includeCallerData, @PluginAttribute(value="includeMappedDiagnosticContext") String includeMappedDiagnosticContext, @PluginElement(value="indexedChronicleConfig") AbstractChronicleAppender.IndexedChronicleCfg chronicleConfig, @PluginElement(value="filter") Filter filter) {
        if (name == null) {
            LOGGER.error("No name provided for BinaryVanillaChronicleAppender");
            return null;
        }
        if (path == null) {
            LOGGER.error("No path provided for BinaryVanillaChronicleAppender");
            return null;
        }
        BinaryIndexedChronicleAppender appender = new BinaryIndexedChronicleAppender(name, filter, path, chronicleConfig);
        if (formatMessage != null) {
            appender.setFormatMessage("true".equalsIgnoreCase(formatMessage));
        }
        if (includeCallerData != null) {
            appender.setIncludeCallerData("true".equalsIgnoreCase(includeCallerData));
        }
        if (includeMappedDiagnosticContext != null) {
            appender.setIncludeMappedDiagnosticContext("true".equalsIgnoreCase(includeMappedDiagnosticContext));
        }
        return appender;
    }
}

