/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.logger;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.openhft.chronicle.logger.ChronicleLogLevel;
import net.openhft.chronicle.logger.LogAppenderConfig;

public class ChronicleLogConfig {
    public static final String KEY_LEVEL = "level";
    public static final String KEY_PATH = "path";
    public static final String KEY_WIRETYPE = "wireType";
    public static final String KEY_APPEND = "append";
    public static final String PLACEHOLDER_START = "${";
    public static final String PLACEHOLDER_END = "}";
    private static final String KEY_PROPERTIES_FILE = "chronicle.logger.properties";
    private static final String KEY_PREFIX = "chronicle.logger.";
    private static final String KEY_PREFIX_ROOT = "chronicle.logger.root.";
    private static final String KEY_CFG_PREFIX = "chronicle.logger.root.cfg.";
    private static final String PLACEHOLDER_PID = "${pid}";
    private static final List<String> DEFAULT_CFG_LOCATIONS = Arrays.asList("chronicle-logger.properties", "config/chronicle-logger.properties");
    private static final String PID = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
    private final Properties properties;
    private final LogAppenderConfig appenderConfig;

    private ChronicleLogConfig(Properties properties, LogAppenderConfig appenderConfig) {
        this.properties = properties;
        this.appenderConfig = appenderConfig;
    }

    public static ChronicleLogConfig load(Properties properties) {
        return new ChronicleLogConfig(properties, ChronicleLogConfig.loadAppenderConfig(properties));
    }

    public static ChronicleLogConfig load(String cfgPath) {
        try {
            return ChronicleLogConfig.load(ChronicleLogConfig.getConfigurationStream(cfgPath));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static ChronicleLogConfig load(InputStream in) {
        if (in != null) {
            Properties properties = new Properties();
            try {
                properties.load(in);
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ChronicleLogConfig.load(ChronicleLogConfig.interpolate(properties));
        }
        System.err.printf("Unable to configure chronicle-logger: configuration file not found in default locations (%s) or System property (%s) is not defined \n", DEFAULT_CFG_LOCATIONS.toString(), KEY_PROPERTIES_FILE);
        return null;
    }

    public static ChronicleLogConfig load() {
        try {
            InputStream is = ChronicleLogConfig.getConfigurationStream(System.getProperty(KEY_PROPERTIES_FILE));
            if (is == null) {
                String location;
                Iterator<String> iterator = DEFAULT_CFG_LOCATIONS.iterator();
                while (iterator.hasNext() && (is = ChronicleLogConfig.getConfigurationStream(location = iterator.next())) == null) {
                }
            }
            if (is != null) {
                return ChronicleLogConfig.load(is);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private static InputStream getConfigurationStream(String cfgPath) throws IOException {
        if (cfgPath != null) {
            File cfgFile = new File(cfgPath);
            if (!cfgFile.exists()) {
                return Thread.currentThread().getContextClassLoader().getResourceAsStream(cfgPath);
            }
            if (cfgFile.canRead()) {
                return new FileInputStream(cfgFile);
            }
        }
        return null;
    }

    private static Properties interpolate(Properties props) {
        int amended;
        do {
            amended = 0;
            for (Map.Entry<Object, Object> entries : props.entrySet()) {
                int startIndex;
                String val = props.getProperty((String)entries.getKey());
                val = val.replace(PLACEHOLDER_PID, PID);
                int endIndex = 0;
                do {
                    if ((startIndex = val.indexOf(PLACEHOLDER_START, endIndex)) == -1 || (endIndex = val.indexOf(PLACEHOLDER_END, startIndex)) == -1) continue;
                    String envKey = val.substring(startIndex + 2, endIndex);
                    String newVal = null;
                    if (props.containsKey(envKey)) {
                        newVal = props.getProperty(envKey);
                    } else if (System.getProperties().containsKey(envKey)) {
                        newVal = System.getProperties().getProperty(envKey);
                    }
                    if (newVal == null) continue;
                    val = val.replace(PLACEHOLDER_START + envKey + PLACEHOLDER_END, newVal);
                    endIndex += newVal.length() - envKey.length() + 3;
                    ++amended;
                } while (startIndex != -1 && endIndex != -1 && endIndex < val.length());
                entries.setValue(val);
            }
        } while (amended > 0);
        return props;
    }

    private static LogAppenderConfig loadAppenderConfig(Properties properties) {
        LogAppenderConfig cfg = new LogAppenderConfig();
        cfg.setProperties(properties, KEY_CFG_PREFIX);
        return cfg;
    }

    public LogAppenderConfig getAppenderConfig() {
        return this.appenderConfig;
    }

    public String getString(String shortName) {
        String name = KEY_PREFIX_ROOT + shortName;
        return this.properties.getProperty(name);
    }

    public String getString(String loggerName, String shortName) {
        String name = KEY_PREFIX + loggerName + "." + shortName;
        String val = this.properties.getProperty(name);
        if (val == null) {
            val = this.getString(shortName);
        }
        return val;
    }

    public Boolean getBoolean(String shortName) {
        return this.getBoolean(shortName, null);
    }

    public Boolean getBoolean(String shortName, boolean defval) {
        String prop = this.getString(shortName);
        return prop != null ? "true".equalsIgnoreCase(prop) : defval;
    }

    public Boolean getBoolean(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Boolean.valueOf("true".equalsIgnoreCase(prop)) : null;
    }

    public Boolean getBoolean(String loggerName, String shortName, boolean defval) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? "true".equalsIgnoreCase(prop) : defval;
    }

    public Integer getInteger(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Integer.valueOf(Integer.parseInt(prop)) : null;
    }

    public Integer getInteger(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Integer.valueOf(Integer.parseInt(prop)) : null;
    }

    public Long getLong(String shortName) {
        String prop = this.getString(shortName);
        return prop != null ? Long.valueOf(Long.parseLong(prop)) : null;
    }

    public Long getLong(String loggerName, String shortName) {
        String prop = this.getString(loggerName, shortName);
        return prop != null ? Long.valueOf(Long.parseLong(prop)) : null;
    }

    public ChronicleLogLevel getLevel(String loggerName) {
        return this.getLevel(loggerName, null);
    }

    public ChronicleLogLevel getLevel(String loggerName, ChronicleLogLevel defVal) {
        String prop = this.getString(loggerName, KEY_LEVEL);
        return prop != null ? ChronicleLogLevel.fromStringLevel(prop) : defVal;
    }
}

