/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.hashing;

import java.nio.ByteOrder;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.algo.hashing.LongHashFunction;
import net.openhft.chronicle.algo.hashing.Primitives;

class MurmurHash_3 {
    private static final MurmurHash_3 INSTANCE = new MurmurHash_3();
    private static final MurmurHash_3 NATIVE_MURMUR = LongHashFunction.NATIVE_LITTLE_ENDIAN ? INSTANCE : BigEndian.access$000();
    private static final long C1 = -8663945395140668459L;
    private static final long C2 = 5545529020109919103L;

    private MurmurHash_3() {
    }

    private static long finalize(long length, long h1, long h2) {
        h1 ^= length;
        h1 += (h2 ^= length);
        h2 += h1;
        h1 = MurmurHash_3.fmix64(h1);
        h2 = MurmurHash_3.fmix64(h2);
        return h1 += h2;
    }

    private static long fmix64(long k) {
        k ^= k >>> 33;
        k *= -49064778989728563L;
        k ^= k >>> 33;
        k *= -4265267296055464877L;
        k ^= k >>> 33;
        return k;
    }

    private static long mixK1(long k1) {
        k1 *= -8663945395140668459L;
        k1 = Long.rotateLeft(k1, 31);
        return k1 *= 5545529020109919103L;
    }

    private static long mixK2(long k2) {
        k2 *= 5545529020109919103L;
        k2 = Long.rotateLeft(k2, 33);
        return k2 *= -8663945395140668459L;
    }

    public static LongHashFunction asLongHashFunctionWithoutSeed() {
        return AsLongHashFunction.INSTANCE;
    }

    public static LongHashFunction asLongHashFunctionWithSeed(long seed) {
        return new AsLongHashFunctionSeeded(seed);
    }

    <T> long fetch64(ReadAccess<T> access, T in, long off) {
        return access.readLong(in, off);
    }

    <T> int fetch32(ReadAccess<T> access, T in, long off) {
        return access.readInt(in, off);
    }

    long toLittleEndian(long v) {
        return v;
    }

    int toLittleEndian(int v) {
        return v;
    }

    int toLittleEndianShort(int unsignedShort) {
        return unsignedShort;
    }

    public <T> long hash(long seed, T input, ReadAccess<T> access, long offset, long length) {
        long k2;
        long k1;
        long h1 = seed;
        long h2 = seed;
        long remaining = length;
        while (remaining >= 16L) {
            k1 = this.fetch64(access, input, offset);
            k2 = this.fetch64(access, input, offset + 8L);
            offset += 16L;
            remaining -= 16L;
            h1 ^= MurmurHash_3.mixK1(k1);
            h1 = Long.rotateLeft(h1, 27);
            h1 += h2;
            h1 = h1 * 5L + 1390208809L;
            h2 ^= MurmurHash_3.mixK2(k2);
            h2 = Long.rotateLeft(h2, 31);
            h2 += h1;
            h2 = h2 * 5L + 944331445L;
        }
        if (remaining > 0L) {
            k1 = 0L;
            k2 = 0L;
            switch ((int)remaining) {
                case 15: {
                    k2 ^= (long)access.readUnsignedByte(input, offset + 14L) << 48;
                }
                case 14: {
                    k2 ^= (long)access.readUnsignedByte(input, offset + 13L) << 40;
                }
                case 13: {
                    k2 ^= (long)access.readUnsignedByte(input, offset + 12L) << 32;
                }
                case 12: {
                    k2 ^= (long)access.readUnsignedByte(input, offset + 11L) << 24;
                }
                case 11: {
                    k2 ^= (long)access.readUnsignedByte(input, offset + 10L) << 16;
                }
                case 10: {
                    k2 ^= (long)access.readUnsignedByte(input, offset + 9L) << 8;
                }
                case 9: {
                    k2 ^= (long)access.readUnsignedByte(input, offset + 8L);
                }
                case 8: {
                    k1 ^= this.fetch64(access, input, offset);
                    break;
                }
                case 7: {
                    k1 ^= (long)access.readUnsignedByte(input, offset + 6L) << 48;
                }
                case 6: {
                    k1 ^= (long)access.readUnsignedByte(input, offset + 5L) << 40;
                }
                case 5: {
                    k1 ^= (long)access.readUnsignedByte(input, offset + 4L) << 32;
                }
                case 4: {
                    k1 ^= Primitives.unsignedInt(this.fetch32(access, input, offset));
                    break;
                }
                case 3: {
                    k1 ^= (long)access.readUnsignedByte(input, offset + 2L) << 16;
                }
                case 2: {
                    k1 ^= (long)access.readUnsignedByte(input, offset + 1L) << 8;
                }
                case 1: {
                    k1 ^= (long)access.readUnsignedByte(input, offset);
                }
                case 0: {
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
            h1 ^= MurmurHash_3.mixK1(k1);
            h2 ^= MurmurHash_3.mixK2(k2);
        }
        return MurmurHash_3.finalize(length, h1, h2);
    }

    private static class AsLongHashFunctionSeeded
    extends AsLongHashFunction {
        private static final long serialVersionUID = 0L;
        private final long seed;
        private final transient long voidHash;

        private AsLongHashFunctionSeeded(long seed) {
            this.seed = seed;
            this.voidHash = MurmurHash_3.finalize(0L, seed, seed);
        }

        @Override
        long seed() {
            return this.seed;
        }

        @Override
        long hashNativeLong(long nativeLong, long len) {
            long seed = this.seed;
            long h1 = seed ^ MurmurHash_3.mixK1(nativeLong);
            long h2 = seed;
            return MurmurHash_3.finalize(len, h1, h2);
        }

        @Override
        public long hashVoid() {
            return this.voidHash;
        }
    }

    private static class AsLongHashFunction
    extends LongHashFunction {
        public static final AsLongHashFunction INSTANCE = new AsLongHashFunction();
        private static final long serialVersionUID = 0L;

        private AsLongHashFunction() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        long seed() {
            return 0L;
        }

        long hashNativeLong(long nativeLong, long len) {
            long h1 = MurmurHash_3.mixK1(nativeLong);
            long h2 = 0L;
            return MurmurHash_3.finalize(len, h1, h2);
        }

        @Override
        public long hashLong(long input) {
            return this.hashNativeLong(NATIVE_MURMUR.toLittleEndian(input), 8L);
        }

        @Override
        public long hashInt(int input) {
            return this.hashNativeLong(Primitives.unsignedInt(NATIVE_MURMUR.toLittleEndian(input)), 4L);
        }

        @Override
        public long hashShort(short input) {
            return this.hashNativeLong(NATIVE_MURMUR.toLittleEndianShort(Primitives.unsignedShort(input)), 2L);
        }

        @Override
        public long hashChar(char input) {
            return this.hashNativeLong(NATIVE_MURMUR.toLittleEndianShort(input), 2L);
        }

        @Override
        public long hashByte(byte input) {
            return this.hashNativeLong(Primitives.unsignedByte(input), 1L);
        }

        @Override
        public long hashVoid() {
            return 0L;
        }

        @Override
        public <T> long hash(T input, ReadAccess<T> access, long off, long len) {
            long seed = this.seed();
            if (access.byteOrder(input) == ByteOrder.LITTLE_ENDIAN) {
                return INSTANCE.hash(seed, input, access, off, len);
            }
            return BigEndian.INSTANCE.hash(seed, input, access, off, len);
        }
    }

    private static class BigEndian
    extends MurmurHash_3 {
        private static final BigEndian INSTANCE = new BigEndian();

        private BigEndian() {
        }

        @Override
        <T> long fetch64(ReadAccess<T> access, T in, long off) {
            return Long.reverseBytes(super.fetch64(access, in, off));
        }

        @Override
        <T> int fetch32(ReadAccess<T> access, T in, long off) {
            return Integer.reverseBytes(super.fetch32(access, in, off));
        }

        @Override
        long toLittleEndian(long v) {
            return Long.reverseBytes(v);
        }

        @Override
        int toLittleEndian(int v) {
            return Integer.reverseBytes(v);
        }

        @Override
        int toLittleEndianShort(int unsignedShort) {
            return (unsignedShort & 0xFF) << 8 | unsignedShort >> 8;
        }
    }
}

