/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import net.openhft.chronicle.algo.bytes.AccessCommon;
import net.openhft.chronicle.algo.bytes.ZeroAccess;

public interface ReadAccess<T>
extends AccessCommon<T> {
    public static ReadAccess<Void> zeros() {
        return ZeroAccess.INSTANCE;
    }

    default public boolean readBoolean(T handle, long offset) {
        return this.readByte(handle, offset) != 0;
    }

    public byte readByte(T var1, long var2);

    default public int readUnsignedByte(T handle, long offset) {
        return this.readByte(handle, offset) & 0xFF;
    }

    public short readShort(T var1, long var2);

    default public int readUnsignedShort(T handle, long offset) {
        return this.readShort(handle, offset) & 0xFFFF;
    }

    default public char readChar(T handle, long offset) {
        return (char)this.readShort(handle, offset);
    }

    public int readInt(T var1, long var2);

    default public long readUnsignedInt(T handle, long offset) {
        return (long)this.readInt(handle, offset) & 0xFFFFFFFFL;
    }

    public long readLong(T var1, long var2);

    default public float readFloat(T handle, long offset) {
        return Float.intBitsToFloat(this.readInt(handle, offset));
    }

    default public double readDouble(T handle, long offset) {
        return Double.longBitsToDouble(this.readLong(handle, offset));
    }

    default public String printable(T handle, long offset) {
        int b = this.readUnsignedByte(handle, offset);
        if (b == 0) {
            return "\u0660";
        }
        if (b < 21) {
            return String.valueOf((char)(b + 9351));
        }
        return String.valueOf((char)b);
    }

    default public int readVolatileInt(T handle, long offset) {
        throw new UnsupportedOperationException();
    }

    default public long readVolatileLong(T handle, long offset) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    default public <S> boolean compareTo(T handle, long offset, ReadAccess<S> sourceAccess, S source, long sourceOffset, long len) {
        long i = 0L;
        while (len - i >= 8L) {
            if (this.readLong(handle, offset + i) != sourceAccess.readLong(source, sourceOffset + i)) {
                return false;
            }
            i += 8L;
        }
        if (len - i >= 4L) {
            if (this.readInt(handle, offset + i) != sourceAccess.readInt(source, sourceOffset + i)) {
                return false;
            }
            i += 4L;
        }
        if (len - i >= 2L) {
            if (this.readShort(handle, offset + i) != sourceAccess.readShort(source, sourceOffset + i)) {
                return false;
            }
            i += 2L;
        }
        return i >= len || this.readByte(handle, offset + i) == sourceAccess.readByte(source, sourceOffset + i);
    }
}

