/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.algo.bytes;

import java.nio.ByteOrder;
import net.openhft.chronicle.algo.bytes.Accessor;
import net.openhft.chronicle.algo.bytes.CharSequenceAccess;
import net.openhft.chronicle.algo.bytes.HotSpotStringAccessor;
import net.openhft.chronicle.algo.bytes.ReadAccess;
import net.openhft.chronicle.core.Jvm;

abstract class CharSequenceAccessor
implements Accessor.Read<CharSequence, CharSequence> {
    static final Accessor.Read<? super String, ?> stringAccessor;
    static final CharSequenceAccessor LITTLE_ENDIAN;
    static final CharSequenceAccessor BIG_ENDIAN;

    private CharSequenceAccessor() {
    }

    static CharSequenceAccessor nativeCharSequenceAccessor() {
        return ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? LITTLE_ENDIAN : BIG_ENDIAN;
    }

    @Override
    public CharSequence handle(CharSequence source) {
        return source;
    }

    @Override
    public long offset(CharSequence source, long index) {
        return index * 2L;
    }

    @Override
    public long size(long size) {
        return size * 2L;
    }

    static {
        LITTLE_ENDIAN = new CharSequenceAccessor(){

            @Override
            public ReadAccess<CharSequence> access() {
                return CharSequenceAccess.LittleEndianCharSequenceAccess.INSTANCE;
            }
        };
        BIG_ENDIAN = new CharSequenceAccessor(){

            @Override
            public ReadAccess<CharSequence> access() {
                return CharSequenceAccess.BigEndianCharSequenceAccess.INSTANCE;
            }
        };
        stringAccessor = Jvm.isJava9Plus() ? HotSpotStringAccessor.JAVA9PLUS : HotSpotStringAccessor.JAVA8;
    }
}

