package jsp.plugins.export;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import net.ontopia.topicmaps.nav2.core.*;
import net.ontopia.topicmaps.nav2.utils.NavigatorUtils;
import net.ontopia.topicmaps.xml.*;
import net.ontopia.topicmaps.core.*;
import net.ontopia.utils.*;
import java.net.URLEncoder;
import net.ontopia.topicmaps.schema.impl.osl.cmdline.Generate;
import net.ontopia.topicmaps.schema.impl.osl.OSLSchema;
import net.ontopia.topicmaps.schema.impl.osl.OSLSchemaWriter;

public final class generate_002dschema_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static java.util.List _jspx_dependants;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    JspFactory _jspxFactory = null;
    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      _jspxFactory = JspFactory.getDefaultFactory();
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;


  
  // retrieve configuration
  NavigatorApplicationIF navApp = NavigatorUtils.getNavigatorApplication(pageContext);

  // get request parameters
  String tmid = request.getParameter("tm");
  TopicMapIF tm = navApp.getTopicMapById(tmid);
  try {

    String type = request.getParameter("schema_type");
    if (type.equals("xml")) {
      type = "text/xml";
    } else {
      type = "application/octet-stream";
      response.setHeader("Content-disposition", "attachment; filename=" +
                         request.getParameter("filename"));
    }
  
    // Response header: contentType and charset determined by application
    // String charset = rconfig.getTopicmapConfig().getCharset();
    String charset = "utf-8";
    response.setContentType(type + "; charset=" + charset); 
   
    String format = request.getParameter("schema_format");
    if (format == null || format.equals("")) {
      // no other possibility at the moment
      format = "osl";
    }
    if (!format.equals("osl")) 
      throw new OntopiaRuntimeException("Unknown schema format!");
  
    // generate topic map schema
    Generate gen = new Generate();
    OSLSchema schema = gen.createSchema(tm);
  
    // deliver / write out schema
    OSLSchemaWriter writer;
    writer = new OSLSchemaWriter(out, charset);
    writer.write(schema);

  } finally {
    navApp.returnTopicMap(tm);
  }

      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      if (_jspxFactory != null) _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
