package jsp.plugins.export;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import net.ontopia.topicmaps.nav2.core.*;
import net.ontopia.topicmaps.nav2.utils.NavigatorUtils;
import net.ontopia.topicmaps.xml.*;
import net.ontopia.topicmaps.core.*;
import net.ontopia.utils.*;
import net.ontopia.topicmaps.utils.rdf.RDFTopicMapWriter;
import net.ontopia.topicmaps.utils.ltm.LTMTopicMapWriter;

public final class export_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {

  private static java.util.List _jspx_dependants;

  public Object getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    JspFactory _jspxFactory = null;
    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;


    try {
      _jspxFactory = JspFactory.getDefaultFactory();
      response.setContentType("text/html");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;

 
  // retrieve configuration
  NavigatorApplicationIF navApp = NavigatorUtils.getNavigatorApplication(pageContext);

  // get request parameters
  String tmid = request.getParameter("tm");
  TopicMapIF tm = navApp.getTopicMapById(tmid);
  try {

    String format = request.getParameter("format");
    String type = request.getParameter("type");
    if (type.equals("xml")) {
      if (format.equals("ltm"))
        type = "text/plain";
      else
        type = "text/xml";
    } else {
      type = "application/octet-stream";
      response.setHeader("Content-disposition", "attachment; filename=" +
                         request.getParameter("filename"));
    }
  
    // Response header: contentType determined by application
    //                  charset always utf-8
    String charset = "utf-8";
    response.setContentType(type + "; charset=" + charset); 
   
    TopicMapWriterIF writer;
    if (format.equals("xtm1")) 
      writer = new XTMTopicMapWriter(out, charset);
    else if (format.equals("xtm2")) 
      writer = new XTM2TopicMapWriter(out, charset);
    else if (format.equals("xtm21")) 
      writer = new XTM21TopicMapWriter(out, charset);
    else if (format.equals("rdf")) 
      writer = new RDFTopicMapWriter(out);
    else if (format.equals("cxtm")) {
      writer = new CanonicalXTMWriter(out);
    } else if (format.equals("ltm")) 
      writer = new LTMTopicMapWriter(out);
    else if (format.equals("tmxml")) 
      writer = new TMXMLWriter(out, charset);
    else
      throw new OntopiaRuntimeException("Unknown export format!");
  
    writer.write(tm);

  } finally {
    navApp.returnTopicMap(tm);
  }

      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
      }
    } finally {
      if (_jspxFactory != null) _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
