/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.ontopia.topicmaps.classify.BlackList;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.ClassifyPluginIF;
import net.ontopia.topicmaps.classify.ClassifyUtils;
import net.ontopia.topicmaps.classify.HttpServletRequestAwareIF;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TopicMapAnalyzer;
import net.ontopia.topicmaps.classify.TopicMapClassification;
import net.ontopia.topicmaps.classify.Variant;
import net.ontopia.topicmaps.core.AssociationIF;
import net.ontopia.topicmaps.core.TopicIF;
import net.ontopia.topicmaps.core.TopicMapBuilderIF;
import net.ontopia.topicmaps.core.TopicMapIF;
import net.ontopia.topicmaps.core.TopicMapStoreIF;
import net.ontopia.topicmaps.nav2.utils.ContextUtils;
import net.ontopia.topicmaps.nav2.utils.NavigatorUtils;
import net.ontopia.topicmaps.query.core.ParsedQueryIF;
import net.ontopia.topicmaps.query.core.QueryProcessorIF;
import net.ontopia.topicmaps.query.core.QueryResultIF;
import net.ontopia.topicmaps.query.utils.QueryUtils;
import net.ontopia.topicmaps.utils.DuplicateSuppressionUtils;
import net.ontopia.topicmaps.utils.TopicStringifiers;
import net.ontopia.utils.ObjectUtils;
import net.ontopia.utils.OntopiaRuntimeException;
import org.apache.commons.lang3.StringUtils;

public class WebChew {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private int visibleRows = Integer.MAX_VALUE;
    private String redirectURI;

    public WebChew(HttpServletRequest request, HttpServletResponse response) {
        this.request = request;
        this.response = response;
    }

    public void setVisibleRows(int visibleRows) {
        this.visibleRows = visibleRows;
    }

    public void setRedirectURI(String redirectURI) {
        this.redirectURI = redirectURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processForm() {
        String removeAssociation;
        String blacklisted;
        HttpSession session = this.request.getSession(true);
        String tmckey = this.getClassificationKey();
        if (this.request.getParameter("reclassify") != null) {
            session.removeAttribute(tmckey);
        }
        if ((blacklisted = this.request.getParameter("blacklisted")) != null && blacklisted.length() > 0) {
            BlackList bl = this.getBlackList();
            bl.addStopWord(blacklisted);
            bl.save();
        }
        if ((removeAssociation = this.request.getParameter("removeAssociation")) != null) {
            try (TopicMapStoreIF store = NavigatorUtils.getTopicMapRepository((ServletContext)session.getServletContext()).getReferenceByKey(this.request.getParameter("tm")).createStore(false);){
                TopicMapIF topicmap = store.getTopicMap();
                AssociationIF assoc = (AssociationIF)topicmap.getObjectById(removeAssociation);
                if (assoc != null) {
                    assoc.remove();
                }
                store.commit();
            }
            catch (Exception e) {
                throw new OntopiaRuntimeException((Throwable)e);
            }
        }
        String[] selected = this.request.getParameterValues("selected");
        if (this.request.getParameter("ok") != null || this.request.getParameter("cancel") != null) {
            try {
                if (this.request.getParameter("ok") != null) {
                    TopicMapClassification tmc = (TopicMapClassification)session.getAttribute(tmckey);
                    if (tmc == null) {
                        return;
                    }
                    try (TopicMapStoreIF store = NavigatorUtils.getTopicMapRepository((ServletContext)session.getServletContext()).getReferenceByKey(this.request.getParameter("tm")).createStore(false);){
                        TopicMapIF topicmap = store.getTopicMap();
                        TopicMapBuilderIF builder = topicmap.getBuilder();
                        TopicIF dtopic = (TopicIF)topicmap.getObjectById(this.request.getParameter("id"));
                        if (selected != null && selected.length > 0) {
                            for (int i = 0; i < selected.length; ++i) {
                                TopicIF ctopic;
                                String termid = selected[i];
                                String at = this.request.getParameter("at-" + termid);
                                if (at == null || "-".equals(at)) continue;
                                String cn = this.request.getParameter("cn-" + termid);
                                String ct = this.request.getParameter("ct-" + termid);
                                if (ct == null || "-".equals(ct)) continue;
                                if (ct.startsWith("new:")) {
                                    String ctoid = ct.substring("new:".length());
                                    TopicIF ctype = (TopicIF)topicmap.getObjectById(ctoid);
                                    if (ctype == null) {
                                        throw new OntopiaRuntimeException("Cannot find topic type: " + ct + " " + ctoid);
                                    }
                                    ctopic = builder.makeTopic(ctype);
                                    builder.makeTopicName(ctopic, cn);
                                } else {
                                    if ("-".equals(ct)) continue;
                                    ctopic = (TopicIF)topicmap.getObjectById(ct);
                                }
                                String[] at_data = StringUtils.split((String)at, (String)":");
                                if (at_data.length != 3) continue;
                                TopicIF atype = (TopicIF)topicmap.getObjectById(at_data[0]);
                                if (atype == null) {
                                    throw new OntopiaRuntimeException("Cannot find association type: " + at);
                                }
                                TopicIF drtype = (TopicIF)topicmap.getObjectById(at_data[1]);
                                if (drtype == null) {
                                    throw new OntopiaRuntimeException("Cannot find document roletype: " + at_data[1]);
                                }
                                TopicIF crtype = (TopicIF)topicmap.getObjectById(at_data[2]);
                                if (crtype == null) {
                                    throw new OntopiaRuntimeException("Cannot find concept roletype: " + at_data[2]);
                                }
                                AssociationIF assoc = builder.makeAssociation(atype);
                                builder.makeAssociationRole(assoc, drtype, dtopic);
                                builder.makeAssociationRole(assoc, crtype, ctopic);
                            }
                            DuplicateSuppressionUtils.removeDuplicateAssociations((TopicIF)dtopic);
                            store.commit();
                        }
                    }
                }
                session.removeAttribute(tmckey);
                this.response.sendRedirect(this.redirectURI);
            }
            catch (Exception e) {
                throw new OntopiaRuntimeException((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BlackList getBlackList() {
        HttpSession session = this.request.getSession(true);
        String blkey = "webchew-blacklist-" + this.request.getParameter("tm");
        HttpSession httpSession = session;
        synchronized (httpSession) {
            BlackList bl = (BlackList)session.getAttribute(blkey);
            if (bl == null) {
                bl = new BlackList(new File(System.getProperty("user.home") + "/.oks/classify/blacklist." + this.request.getParameter("tm")));
                session.setAttribute(blkey, (Object)bl);
            }
            return bl;
        }
    }

    private String getClassificationKey() {
        return "webchew-" + this.request.getParameter("tm") + ":" + this.request.getParameter("id");
    }

    public WebClassification getClassification() {
        try {
            HttpSession session = this.request.getSession(true);
            String tmckey = this.getClassificationKey();
            TopicMapClassification tmc = (TopicMapClassification)session.getAttribute(tmckey);
            if (tmc == null) {
                TopicMapIF topicmap = ContextUtils.getTopicMap((ServletRequest)this.request);
                TopicIF topic = (TopicIF)topicmap.getObjectById(this.request.getParameter("id"));
                ClassifyPluginIF cp = WebChew.getPlugin(this.request);
                ClassifiableContentIF cc = cp.getClassifiableContent(topic);
                if (cc == null) {
                    cc = ClassifyUtils.getFileUploadContent(this.request);
                }
                if (cc != null) {
                    tmc = this.classifyContent(cc, topicmap);
                    session.setAttribute(tmckey, (Object)tmc);
                }
            }
            return tmc == null ? null : new WebClassification(tmc);
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    public static ClassifyPluginIF getPlugin(HttpServletRequest request) {
        ClassifyPluginIF cp;
        HttpSession session = request.getSession(true);
        ServletContext scontext = session.getServletContext();
        String pclass = scontext.getInitParameter("classify_plugin");
        if (pclass == null) {
            pclass = "net.ontopia.topicmaps.classify.DefaultPlugin";
        }
        if ((cp = (ClassifyPluginIF)ObjectUtils.newInstance((String)pclass)) instanceof HttpServletRequestAwareIF) {
            ((HttpServletRequestAwareIF)((Object)cp)).setRequest(request);
        }
        return cp;
    }

    private TopicMapClassification classifyContent(ClassifiableContentIF cc, TopicMapIF topicmap) {
        try {
            TopicMapClassification tmc = new TopicMapClassification(topicmap);
            BlackList bl = this.getBlackList();
            if (bl != null) {
                tmc.setCustomTermAnalyzer(bl);
            }
            tmc.classify(cc);
            return tmc;
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    public class WebTerm {
        private WebClassification wc;
        private Term term;
        private int sequenceId;
        private List<TopicIF> candidates;

        WebTerm(WebClassification wc, Term term, int sequenceId) {
            this.wc = wc;
            this.term = term;
            this.sequenceId = sequenceId;
            this.candidates = new ArrayList<TopicIF>();
            Variant[] variants = term.getVariantsByRank();
            for (int i = 0; i < variants.length; ++i) {
                for (TopicIF c : wc.tmc.getTopics(variants[i])) {
                    if (this.candidates.contains(c)) continue;
                    this.candidates.add(c);
                }
            }
        }

        public String getId() {
            return this.term.getStem();
        }

        public int getSequenceId() {
            return this.sequenceId;
        }

        public boolean getSelected() {
            String id = this.getId();
            String[] selected = WebChew.this.request.getParameterValues("selected");
            if (selected != null && selected.length > 0) {
                for (int i = 0; i < selected.length; ++i) {
                    if (!id.equals(selected[i])) continue;
                    return true;
                }
            }
            if (selected == null || selected.length == 0) {
                return this.getHasCandidateTopics() && this.getDefaultAssociationType() != null;
            }
            return false;
        }

        public String getNameField() {
            return "cn-" + this.getId();
        }

        public String getNameValue() {
            String value = WebChew.this.request.getParameter(this.getNameField());
            if (value != null) {
                return value;
            }
            return this.term.getPreferredName();
        }

        public String getNameTitle() {
            return this.term.getStem() + ": " + StringUtils.join((Object[])this.term.getVariants(), (String)" | ");
        }

        public double getScore() {
            return this.term.getScore();
        }

        public double getScorePercent() {
            return 100.0 * this.term.getScore();
        }

        public int getOccurrences() {
            return this.term.getOccurrences();
        }

        public String getCandidateTopicField() {
            return "ct-" + this.getId();
        }

        public boolean getHasCandidateTopics() {
            return !this.candidates.isEmpty();
        }

        public Collection<TopicIF> getCandidateTopics() {
            return this.candidates;
        }

        public String getAssociationTypeField() {
            return "at-" + this.getId();
        }

        public TopicMapAnalyzer.AssociationType getDefaultAssociationType() {
            boolean hasCandidates = this.getHasCandidateTopics();
            double tscore = this.getScore();
            TopicMapAnalyzer.AssociationType ttype = null;
            double ttscore = -1.0;
            for (TopicMapAnalyzer.AssociationType xtype : this.wc.getAssociationTypes()) {
                double xscore = xtype.getScoreThreshold(hasCandidates);
                if (!(xscore >= 0.0) || !(tscore > xscore) || ttype != null && !(ttscore < xscore)) continue;
                ttype = xtype;
                ttscore = ttype.getScoreThreshold(hasCandidates);
            }
            return ttype;
        }
    }

    public class ExistingAssociation {
        protected String associationId;
        protected String associationName;
        protected String associatedTopicName;

        public String getAssociationId() {
            return this.associationId;
        }

        public String getAssociationName() {
            return this.associationName;
        }

        public String getAssociatedTopicName() {
            return this.associatedTopicName;
        }
    }

    public class WebClassification {
        private TopicMapClassification tmc;
        private List<WebTerm> topterms;

        WebClassification(TopicMapClassification tmc) {
            this.tmc = tmc;
            Term[] terms = tmc.getTermDatabase().getTermsByRank();
            this.topterms = new ArrayList<WebTerm>(WebChew.this.visibleRows);
            BlackList bl = WebChew.this.getBlackList();
            for (int i = 0; i < terms.length && this.topterms.size() < WebChew.this.visibleRows; ++i) {
                Term term = terms[i];
                if (bl != null && bl.isStopWord(term.getPreferredName())) continue;
                this.topterms.add(new WebTerm(this, term, i));
            }
        }

        public List<WebTerm> getTerms() {
            return this.topterms;
        }

        public Collection<TopicIF> getCandidateTypes() {
            return this.tmc.getCandidateTypes();
        }

        public Collection<TopicMapAnalyzer.AssociationType> getAssociationTypes() {
            return this.tmc.getAssociationTypes();
        }

        public Collection<ExistingAssociation> getExistingAssociations() {
            ArrayList<ExistingAssociation> result = new ArrayList<ExistingAssociation>();
            try {
                TopicMapIF topicmap = ContextUtils.getTopicMap((ServletRequest)WebChew.this.request);
                QueryProcessorIF qp = QueryUtils.getQueryProcessor((TopicMapIF)topicmap);
                ParsedQueryIF pq = qp.parse("select $A, $O from role-player($R1, %TOPIC%), type($R1, %CRTYPE%), association-role($A, $R1), type($A, %ATYPE%), association-role($A, $R2), $R1 /= $R2, type($R2, %PRTYPE%), role-player($R2, $O)?");
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("TOPIC", topicmap.getObjectById(WebChew.this.request.getParameter("id")));
                for (TopicMapAnalyzer.AssociationType _atype : this.getAssociationTypes()) {
                    TopicIF atype = (TopicIF)topicmap.getObjectById(_atype.getAssociationTypeId());
                    TopicIF crtype = (TopicIF)topicmap.getObjectById(_atype.getContentRoleTypeId());
                    TopicIF prtype = (TopicIF)topicmap.getObjectById(_atype.getTopicRoleTypeId());
                    params.put("ATYPE", atype);
                    params.put("CRTYPE", crtype);
                    params.put("PRTYPE", prtype);
                    QueryResultIF qr = pq.execute(params);
                    while (qr.next()) {
                        AssociationIF assoc = (AssociationIF)qr.getValue(0);
                        TopicIF player = (TopicIF)qr.getValue(1);
                        ExistingAssociation x = new ExistingAssociation();
                        x.associationId = assoc.getObjectId();
                        x.associationName = TopicStringifiers.toString((TopicIF)atype, (TopicIF)crtype);
                        x.associatedTopicName = TopicStringifiers.toString((TopicIF)player);
                        result.add(x);
                    }
                }
            }
            catch (Exception e) {
                throw new OntopiaRuntimeException((Throwable)e);
            }
            return result;
        }
    }
}

