/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermDatabase;
import net.ontopia.topicmaps.classify.Variant;
import net.ontopia.topicmaps.core.TopicIF;
import net.ontopia.topicmaps.core.TopicMapIF;
import net.ontopia.topicmaps.core.TopicNameIF;
import net.ontopia.topicmaps.core.VariantNameIF;
import net.ontopia.topicmaps.query.core.ParsedQueryIF;
import net.ontopia.topicmaps.query.core.QueryProcessorIF;
import net.ontopia.topicmaps.query.core.QueryResultIF;
import net.ontopia.topicmaps.query.utils.QueryUtils;
import net.ontopia.topicmaps.utils.TopicStringifiers;
import net.ontopia.utils.OntopiaRuntimeException;

public class TopicMapAnalyzer
implements TermAnalyzerIF {
    private TermDatabase tdb;
    private ParsedQueryIF pq_byName;
    private Collection<TopicIF> ctypes;
    private List<TopicIF> ctypes_sorted;
    private Map<TopicIF, AssociationType> atypes;
    private Collection<TopicIF> atopics = new HashSet<TopicIF>();
    private Map<String, Variant> smap = new HashMap<String, Variant>();
    private Map<String, Collection<TopicIF>> vtopics = new HashMap<String, Collection<TopicIF>>();
    private double matchFactor = 4.0;

    public TopicMapAnalyzer(TopicMapIF topicmap) {
        try {
            QueryProcessorIF qp = QueryUtils.getQueryProcessor((TopicMapIF)topicmap);
            this.pq_byName = qp.parse("select $T from topic-name($T, $N), value($N, %VALUE%)?");
            this.ctypes = new HashSet<TopicIF>();
            this.ctypes_sorted = new ArrayList<TopicIF>();
            this.atypes = new HashMap<TopicIF, AssociationType>();
            QueryResultIF qr = qp.execute("/* #OPTION: optimizer.reorder = false */ using on for i\"http://psi.ontopia.net/ontology/\" using cl for i\"http://psi.ontopia.net/classify/\" using xtm for i\"http://www.topicmaps.org/xtm/1.0/core.xtm#\" descendant-of($ANC, $DES) :-  { xtm:superclass-subclass($ANC : xtm:superclass, $DES : xtm:subclass)  | xtm:superclass-subclass($ANC : xtm:superclass, $MID : xtm:subclass), descendant-of($MID, $DES) }. has-role-field($PT, $AT, $RT) :-  { on:has-field($AT : on:field, $PT : on:topic-type, $RT : on:role-type)  | xtm:superclass-subclass($PT : xtm:subclass, $XT : xtm:superclass), has-role-field($XT, $AT, $RT) }. select $CTYPE, $AT, $PRT, $CRT, $ASCORE, $USCORE from subject-identifier($CT, \"http://psi.ontopia.net/classify/classification-type\"), type($A, $CT), association-role($A, $R1), type($R1, $CAT), subject-identifier($CAT, \"http://psi.ontopia.net/classify/classified-association-type\"), association-role($A, $R2), type($R2, $CTT), subject-identifier($CTT, \"http://psi.ontopia.net/classify/classified-topic-type\"), role-player($R1, $AT), role-player($R2, $PTYPE), { occurrence($AT, $O1), type($O1, $OT1), subject-identifier($OT1, \"http://psi.ontopia.net/classify/score-threshold-with-candidates\"), value($O1, $ASCORE)}, { occurrence($AT, $O2), type($O2, $OT2), subject-identifier($OT2, \"http://psi.ontopia.net/classify/score-threshold\"), value($O2, $USCORE)}, has-role-field($PTYPE, $AT, $PRT), has-role-field($CTYPE, $AT, $CRT), $PRT /= $CRT, topic($CTYPE)order by $CTYPE?");
            while (qr.next()) {
                AssociationType at;
                TopicIF ctype = (TopicIF)qr.getValue(0);
                TopicIF atype = (TopicIF)qr.getValue(1);
                TopicIF prtype = (TopicIF)qr.getValue(2);
                TopicIF crtype = (TopicIF)qr.getValue(3);
                String asc = (String)qr.getValue(4);
                String usc = (String)qr.getValue(5);
                if (this.ctypes.add(ctype)) {
                    this.ctypes_sorted.add(ctype);
                }
                if ((at = this.atypes.get(atype)) == null) {
                    double ascore = -1.0;
                    if (asc != null) {
                        try {
                            ascore = Double.parseDouble(asc);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    double uscore = -1.0;
                    if (usc != null) {
                        try {
                            uscore = Double.parseDouble(usc);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    at = new AssociationType(atype, prtype, crtype, ascore, uscore);
                    this.atypes.put(atype, at);
                }
                at.addCandidateType(ctype);
            }
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void analyzeTerm(Term term) {
        try {
            int foundMatches = 0;
            Variant[] variants = term.getVariants();
            for (int i = 0; i < variants.length; ++i) {
                Variant variant = variants[i];
                try (QueryResultIF qr = this.pq_byName.execute(Collections.singletonMap("VALUE", variant.getValue()));){
                    while (qr.next()) {
                        TopicIF topic = (TopicIF)qr.getValue(0);
                        boolean validType = false;
                        for (TopicIF type : topic.getTypes()) {
                            if (!this.ctypes.contains(type)) continue;
                            validType = true;
                            break;
                        }
                        if (!validType) continue;
                        String value = variant.getValue();
                        this.smap.put(value, variant);
                        Collection<TopicIF> matching = this.vtopics.get(value);
                        if (matching == null) {
                            matching = new HashSet<TopicIF>();
                            this.vtopics.put(value, matching);
                        }
                        matching.add(topic);
                        this.atopics.add(topic);
                        ++foundMatches;
                    }
                    continue;
                }
            }
            if (foundMatches > 0) {
                term.multiplyScore(this.matchFactor, "found in topic map");
            }
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    @Override
    public void startAnalysis(TermDatabase tdb) {
        this.tdb = tdb;
    }

    @Override
    public void endAnalysis() {
        for (TopicIF topic : this.atopics) {
            Term term = null;
            for (TopicNameIF bname : topic.getTopicNames()) {
                term = this.createTerm(term, bname.getValue());
                for (VariantNameIF vname : bname.getVariants()) {
                    term = this.createTerm(term, vname.getValue());
                }
            }
        }
        this.tdb = null;
    }

    private Term createTerm(Term term, String value) {
        if (value == null) {
            return term;
        }
        Variant variant = this.tdb.getVariant(value);
        if (variant != null) {
            if (term == null) {
                return variant.getTerm();
            }
            this.tdb.mergeTerms(term, variant.getTerm());
        }
        return term;
    }

    public Collection<TopicIF> getTopics(Variant variant) {
        HashSet result = this.vtopics.get(variant.getValue());
        return result == null ? new HashSet() : result;
    }

    public Collection<TopicIF> getCandidateTypes() {
        return this.ctypes_sorted;
    }

    public Collection<AssociationType> getAssociationTypes() {
        return this.atypes.values();
    }

    public static class AssociationType {
        public TopicIF atype;
        public TopicIF prtype;
        public TopicIF crtype;
        public double ascore;
        public double uscore;
        public Collection<TopicIF> ctypes = new HashSet<TopicIF>();

        AssociationType(TopicIF atype, TopicIF prtype, TopicIF crtype, double ascore, double uscore) {
            this.atype = atype;
            this.prtype = prtype;
            this.crtype = crtype;
            this.ascore = ascore;
            this.uscore = uscore;
        }

        public void addCandidateType(TopicIF ctype) {
            this.ctypes.add(ctype);
        }

        public String getKey() {
            return this.atype.getObjectId() + ":" + this.prtype.getObjectId() + ":" + this.crtype.getObjectId();
        }

        public String getAssociationTypeId() {
            return this.atype.getObjectId();
        }

        public String getContentRoleTypeId() {
            return this.prtype.getObjectId();
        }

        public String getTopicRoleTypeId() {
            return this.crtype.getObjectId();
        }

        public String getName() {
            return TopicStringifiers.toString((TopicIF)this.atype, (TopicIF)this.prtype);
        }

        public double getScoreThreshold(boolean hasCandidates) {
            if (hasCandidates) {
                return this.ascore >= 0.0 ? this.ascore : this.uscore;
            }
            return this.uscore >= 0.0 ? this.uscore : this.ascore;
        }
    }
}

