/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.ClassifyPluginIF;
import net.ontopia.topicmaps.core.TopicIF;
import net.ontopia.topicmaps.xml.XTMFragmentExporter;
import net.ontopia.utils.OntopiaRuntimeException;
import net.ontopia.xml.PrettyPrinter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TopicContentPlugin
implements ClassifyPluginIF {
    @Override
    public boolean isClassifiable(TopicIF topic) {
        return true;
    }

    @Override
    public ClassifiableContentIF getClassifiableContent(TopicIF topic) {
        return new TopicAsContent(topic);
    }

    public static class TopicAsContent
    implements ClassifiableContentIF {
        private TopicIF topic;

        public TopicAsContent(TopicIF topic) {
            this.topic = topic;
        }

        @Override
        public String getIdentifier() {
            return this.topic.getObjectId();
        }

        @Override
        public byte[] getContent() {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrettyPrinter pp = new PrettyPrinter((OutputStream)out);
                XTMFragmentExporter exporter = new XTMFragmentExporter();
                exporter.exportAll(Collections.singleton(this.topic).iterator(), (ContentHandler)pp);
                pp.endDocument();
                return out.toByteArray();
            }
            catch (SAXException e) {
                throw new OntopiaRuntimeException((Throwable)e);
            }
            catch (IOException e) {
                throw new OntopiaRuntimeException((Throwable)e);
            }
        }
    }
}

