/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.ArrayList;
import java.util.List;
import net.ontopia.topicmaps.classify.TextBlock;
import net.ontopia.topicmaps.classify.TokenVisitor;

public class Region {
    private String name;
    private Region parent;
    private List<Object> children = new ArrayList<Object>();

    Region() {
    }

    Region(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Region getParent() {
        return this.parent;
    }

    public void setParent(Region parent) {
        this.parent = parent;
    }

    public List<Object> getChildren() {
        return this.children;
    }

    public void addText(char[] ch, int start, int length) {
        Object last;
        int size = this.children.size();
        if (size > 0 && (last = this.children.get(size - 1)) instanceof TextBlock) {
            ((TextBlock)last).addText(ch, start, length);
            return;
        }
        TextBlock tb = new TextBlock();
        tb.addText(ch, start, length);
        this.children.add(tb);
    }

    public void addRegion(Region child) {
        this.children.add(child);
    }

    public void dump() {
        this.dump(-1);
    }

    protected void dump(int level) {
        int a;
        if (this.name != null) {
            for (a = 0; a < level * 2; ++a) {
                System.out.print(' ');
            }
            System.out.println("<" + this.name + ">");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            Object o = this.children.get(i);
            if (o instanceof TextBlock) {
                System.out.println(((TextBlock)o).getTokens());
                continue;
            }
            ((Region)o).dump(++level);
            --level;
        }
        if (this.name != null) {
            for (a = 0; a < level * 2; ++a) {
                System.out.print(' ');
            }
            System.out.println("</" + this.name + ">");
        }
    }

    public void visitTokens(TokenVisitor visitor) {
        for (int i = 0; i < this.children.size(); ++i) {
            Object o = this.children.get(i);
            if (o instanceof TextBlock) {
                ((TextBlock)o).visitTokens(visitor);
                continue;
            }
            ((Region)o).visitTokens(visitor);
        }
    }
}

