/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.FormatModule;
import net.ontopia.topicmaps.classify.FormatModuleIF;
import net.ontopia.topicmaps.classify.TextHandlerIF;
import net.ontopia.utils.OntopiaRuntimeException;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShowFactory;

public class PowerPointFormatModule
implements FormatModuleIF {
    protected String[] extensions = new String[]{".ppt", ".pot", ".pps"};
    protected byte[] magicBytes = new byte[]{-48, -49, 17, -32, -95, -79, 26, -31, 0, 0, 0, 0, 0, 0, 0, 0};

    @Override
    public boolean matchesContent(ClassifiableContentIF cc) {
        return false;
    }

    @Override
    public boolean matchesIdentifier(ClassifiableContentIF cc) {
        boolean matches = FormatModule.matchesExtension(cc.getIdentifier(), this.extensions);
        if (!matches) {
            return false;
        }
        return FormatModule.startsWith(cc.getContent(), this.magicBytes);
    }

    @Override
    public void readContent(ClassifiableContentIF cc, TextHandlerIF handler) {
        try {
            SlideShowExtractor extractor = new SlideShowExtractor(SlideShowFactory.create((InputStream)new ByteArrayInputStream(cc.getContent())));
            String s = extractor.getText();
            char[] c = s.toCharArray();
            handler.startRegion("document");
            handler.text(c, 0, c.length);
            handler.endRegion();
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }
}

