/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.FormatModule;
import net.ontopia.topicmaps.classify.FormatModuleIF;
import net.ontopia.topicmaps.classify.TextHandlerIF;
import net.ontopia.utils.OntopiaRuntimeException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.text.PDFTextStripper;

public class PDFFormatModule
implements FormatModuleIF {
    protected String[] extensions = new String[]{".pdf"};
    protected byte[] magicBytes = FormatModule.getBytes("%PDF-");

    @Override
    public boolean matchesContent(ClassifiableContentIF cc) {
        return FormatModule.startsWith(cc.getContent(), this.magicBytes);
    }

    @Override
    public boolean matchesIdentifier(ClassifiableContentIF cc) {
        return FormatModule.matchesExtension(cc.getIdentifier(), this.extensions);
    }

    @Override
    public void readContent(ClassifiableContentIF cc, TextHandlerIF handler) {
        try {
            PDDocument pdoc = PDDocument.load((InputStream)new BufferedInputStream(new ByteArrayInputStream(cc.getContent())));
            PDFTextStripper stripper = new PDFTextStripper();
            String s = stripper.getText(pdoc);
            pdoc.close();
            char[] c = s.toCharArray();
            handler.startRegion("document");
            handler.text(c, 0, c.length);
            handler.endRegion();
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }
}

