/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.FormatModule;
import net.ontopia.topicmaps.classify.FormatModuleIF;
import net.ontopia.topicmaps.classify.TextHandlerIF;
import net.ontopia.utils.OntopiaRuntimeException;
import org.apache.poi.sl.extractor.SlideShowExtractor;
import org.apache.poi.sl.usermodel.SlideShowFactory;

public class OOXMLPowerpointFormatModule
implements FormatModuleIF {
    protected String[] extensions = new String[]{".pptx"};
    protected byte[] magicBytes = new byte[]{80, 75, 3, 4};

    @Override
    public boolean matchesContent(ClassifiableContentIF cc) {
        return false;
    }

    @Override
    public boolean matchesIdentifier(ClassifiableContentIF cc) {
        boolean matches = FormatModule.matchesExtension(cc.getIdentifier(), this.extensions);
        if (!matches) {
            return false;
        }
        return FormatModule.startsWith(cc.getContent(), this.magicBytes);
    }

    @Override
    public void readContent(ClassifiableContentIF cc, TextHandlerIF handler) {
        try {
            SlideShowExtractor extractor = new SlideShowExtractor(SlideShowFactory.create((InputStream)new ByteArrayInputStream(cc.getContent())));
            String s = extractor.getText();
            char[] c = s.toCharArray();
            handler.startRegion("document");
            handler.text(c, 0, c.length);
            handler.endRegion();
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }
}

