/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.FormatModuleIF;
import net.ontopia.topicmaps.classify.HTMLFormatModule;
import net.ontopia.topicmaps.classify.OOXMLPowerpointFormatModule;
import net.ontopia.topicmaps.classify.OOXMLWordFormatModule;
import net.ontopia.topicmaps.classify.PDFFormatModule;
import net.ontopia.topicmaps.classify.PlainTextFormatModule;
import net.ontopia.topicmaps.classify.PowerPointFormatModule;
import net.ontopia.topicmaps.classify.TextHandlerIF;
import net.ontopia.topicmaps.classify.WordFormatModule;
import net.ontopia.topicmaps.classify.XMLFormatModule;
import net.ontopia.utils.OntopiaRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormatModule
implements FormatModuleIF {
    private static Logger log = LoggerFactory.getLogger((String)FormatModule.class.getName());
    protected List<FormatModuleIF> modules = new ArrayList<FormatModuleIF>();
    protected FormatModuleIF fallout_module;
    private static byte[][] boms = new byte[][]{{-17, -69, -65}, {-2, -1}, {-1, -2}, {0, 0, -2, -1}, {-1, -2, 0, 0}};
    private static String[] bomnames = new String[]{"UTF-8", "UTF-16BE", "UTF-16LE", "UTF-32BE", "UTF-32LE"};

    public FormatModule() {
        this.modules.add(new XMLFormatModule());
        this.modules.add(new HTMLFormatModule());
        this.modules.add(new PDFFormatModule());
        this.modules.add(new WordFormatModule());
        this.modules.add(new PowerPointFormatModule());
        this.modules.add(new OOXMLWordFormatModule());
        this.modules.add(new OOXMLPowerpointFormatModule());
        this.fallout_module = new PlainTextFormatModule();
        this.modules.add(this.fallout_module);
    }

    @Override
    public boolean matchesContent(ClassifiableContentIF cc) {
        return true;
    }

    @Override
    public boolean matchesIdentifier(ClassifiableContentIF cc) {
        return true;
    }

    @Override
    public void readContent(ClassifiableContentIF cc, TextHandlerIF handler) {
        FormatModuleIF fm = this.detectFormat(cc);
        fm.readContent(cc, handler);
    }

    public FormatModuleIF detectFormat(ClassifiableContentIF cc) {
        FormatModuleIF fm;
        int i;
        for (i = 0; i < this.modules.size(); ++i) {
            fm = this.modules.get(i);
            if (!fm.matchesContent(cc)) continue;
            log.debug("Match content: " + cc.getIdentifier() + ", format: " + fm);
            return fm;
        }
        for (i = 0; i < this.modules.size(); ++i) {
            fm = this.modules.get(i);
            if (!fm.matchesIdentifier(cc)) continue;
            log.debug("Match uri: " + cc.getIdentifier() + ", format: " + fm);
            return fm;
        }
        return this.fallout_module;
    }

    public static boolean matchesExtension(String uri, String[] extensions) {
        if (extensions == null) {
            return false;
        }
        String luri = uri.toLowerCase();
        for (int i = 0; i < extensions.length; ++i) {
            if (!luri.endsWith(extensions[i])) continue;
            return true;
        }
        return false;
    }

    public static String getCharSetName(int charSet) {
        return bomnames[charSet];
    }

    public static int getOffset(int charSet) {
        return boms[charSet].length - 1;
    }

    public static int detectCharSet(byte[] content) {
        for (int i = 0; i < boms.length; ++i) {
            byte[] bom = boms[i];
            if (!FormatModule.startsWith(content, bom)) continue;
            return i;
        }
        return -1;
    }

    public static byte[] getBytes(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    public static byte[][] getBytes(String[] s) {
        try {
            byte[][] b = new byte[s.length][];
            for (int i = 0; i < s.length; ++i) {
                b[i] = s[i].getBytes("UTF-8");
            }
            return b;
        }
        catch (UnsupportedEncodingException e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    public static boolean startsWith(byte[] content, byte[] s) {
        if (content == null || content.length < s.length) {
            return false;
        }
        for (int i = 0; i < s.length; ++i) {
            if (content[i] == s[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWithSkipWhitespace(byte[] content, byte[][] ss) {
        int offset = FormatModule.getLeadingWhitespace(content);
        block0: for (int i = 0; i < ss.length; ++i) {
            byte[] s = ss[i];
            for (int o = offset; o < s.length; ++o) {
                if (content[o + offset] != s[o]) continue block0;
            }
            return true;
        }
        return false;
    }

    public static boolean startsWithSkipWhitespace(byte[] content, byte[] s) {
        int offset = FormatModule.getLeadingWhitespace(content);
        for (int i = 0; i < s.length; ++i) {
            if (content[i + offset] == s[i]) continue;
            return false;
        }
        return true;
    }

    private static int getLeadingWhitespace(byte[] content) {
        char c;
        int offset = 0;
        for (int i = 0; i < content.length && (Character.isWhitespace(c = (char)content[i]) || c == '\u0000' || c == '\u00ff' || c == '\u00fe' || c == '\u00ef' || c == '\u00ef' || c == '\u00bb' || c == '\u00bf'); ++i) {
            ++offset;
        }
        return offset;
    }
}

