/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.ClassifyPluginIF;
import net.ontopia.topicmaps.classify.ClassifyUtils;
import net.ontopia.topicmaps.classify.HttpServletRequestAwareIF;
import net.ontopia.topicmaps.core.TopicIF;
import net.ontopia.topicmaps.core.TopicMapIF;
import net.ontopia.topicmaps.query.core.QueryProcessorIF;
import net.ontopia.topicmaps.query.core.QueryResultIF;
import net.ontopia.topicmaps.query.utils.QueryUtils;
import net.ontopia.utils.OntopiaRuntimeException;

public class ConferencePlugin
implements ClassifyPluginIF,
HttpServletRequestAwareIF {
    private HttpServletRequest request;

    @Override
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClassifiable(TopicIF topic) {
        boolean bl;
        if (topic == null) {
            return false;
        }
        TopicMapIF tm = topic.getTopicMap();
        if (tm == null) {
            return false;
        }
        QueryProcessorIF qp = QueryUtils.getQueryProcessor((TopicMapIF)tm);
        QueryResultIF qr = qp.execute("subject-identifier($PAPERTYPE, \"http://psi.example.org/paper\"), instance-of(%topic%, $PAPERTYPE)?", Collections.singletonMap("topic", topic));
        try {
            bl = qr.next();
        }
        catch (Throwable throwable) {
            try {
                qr.close();
                throw throwable;
            }
            catch (Throwable e) {
                throw new OntopiaRuntimeException(e);
            }
        }
        qr.close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ClassifiableContentIF getClassifiableContent(TopicIF topic) {
        if (topic == null) {
            return null;
        }
        TopicMapIF tm = topic.getTopicMap();
        if (tm == null) {
            return null;
        }
        QueryProcessorIF qp = QueryUtils.getQueryProcessor((TopicMapIF)tm);
        try (QueryResultIF qr = qp.execute("import \"http://psi.ontopia.net/tolog/string/\" as str subject-identifier(%topic%, $SUBIND), str:starts-with($SUBIND, \"http://psi.example.org/paper/\")?", Collections.singletonMap("topic", topic));){
            if (qr.next()) {
                String _identifier = (String)qr.getValue(0);
                String identifier = _identifier.substring("http://psi.example.org/paper/".length());
                String path = this.getResolvedPaperPath();
                String infile = path + File.separator + identifier.toLowerCase() + ".xml";
                ClassifiableContentIF cc = ClassifyUtils.getClassifiableContent(infile);
                if (cc != null) {
                    ClassifiableContentIF classifiableContentIF = cc;
                    return classifiableContentIF;
                }
            }
            ClassifiableContentIF classifiableContentIF = null;
            return classifiableContentIF;
        }
        catch (Throwable e) {
            throw new OntopiaRuntimeException(e);
        }
    }

    protected String getResolvedPaperPath() {
        try {
            return new File(this.request.getRealPath("/") + "../conference/WEB-INF/papers/").getCanonicalPath();
        }
        catch (IOException e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }
}

