/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.PrintStream;
import net.ontopia.topicmaps.classify.SimpleClassifier;
import net.ontopia.topicmaps.classify.TermDatabase;
import net.ontopia.topicmaps.core.TopicMapIF;
import net.ontopia.topicmaps.utils.ImportExportUtils;
import net.ontopia.utils.CmdlineOptions;
import net.ontopia.utils.CmdlineUtils;

public class Chew {
    public static void main(String[] argv) throws Exception {
        CmdlineUtils.initializeLogging();
        CmdlineOptions options = new CmdlineOptions("Chew", argv);
        CmdlineUtils.registerLoggingOptions((CmdlineOptions)options);
        OptionsListener ohandler = new OptionsListener();
        options.addLong((CmdlineOptions.ListenerIF)ohandler, "terms", 't', true);
        try {
            options.parse();
        }
        catch (CmdlineOptions.OptionsException e) {
            System.err.println("Error: " + e.getMessage());
            System.exit(1);
        }
        String[] args = options.getArguments();
        if (args.length == 0 || args.length > 2) {
            Chew.usage();
            System.exit(3);
        }
        String infile = args.length == 1 ? args[0] : args[1];
        TopicMapIF topicmap = args.length == 2 ? ImportExportUtils.getReader((String)args[0]).read() : null;
        TermDatabase tdb = SimpleClassifier.classify(infile, topicmap);
        tdb.dump(ohandler.terms);
    }

    private static void usage() {
        System.out.println("java net.ontopia.topicmaps.classify.Chew [options] <topicmapuri> <inputfile>");
        System.out.println("");
        System.out.println("  Performs auto-classification of a document against a topic map.");
        System.out.println("");
        System.out.println("  Options:");
        CmdlineUtils.printLoggingOptionsUsage((PrintStream)System.out);
        System.out.println("    --terms=<number> : number of terms to output (default: 30)");
        System.out.println("");
        System.out.println("  <topicmapuri>:   the topic map to classify against (optional)");
        System.out.println("  <inputfile>:   the document to classify");
        System.out.println("");
    }

    private static class OptionsListener
    implements CmdlineOptions.ListenerIF {
        private int terms = 30;

        private OptionsListener() {
        }

        public void processOption(char option, String value) {
            if (option == 't') {
                this.terms = Integer.valueOf(value);
            }
        }
    }
}

