/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CharacterAnalyzer
implements TermAnalyzerIF {
    private static Logger log = LoggerFactory.getLogger((String)CharacterAnalyzer.class.getName());
    private static final CharacterAnalyzer INSTANCE = new CharacterAnalyzer();
    private static double FACTOR_NO_LETTERS = 0.05;
    private static double FACTOR_DIGITS_AND_OTHER = 0.1;
    private static double FACTOR_DIGITS = 0.3;
    private static double FACTOR_OTHER = 0.8;

    public static CharacterAnalyzer getInstance() {
        return INSTANCE;
    }

    @Override
    public void startAnalysis(TermDatabase tdb) {
    }

    @Override
    public void analyzeTerm(Term term) {
        double score;
        String stem = term.getStem();
        int length = stem.length();
        int cnt_letters = 0;
        int cnt_digits = 0;
        int cnt_other = 0;
        for (int i = 0; i < length; ++i) {
            char c = stem.charAt(i);
            if (Character.isLetter(c) || Character.isWhitespace(c)) {
                ++cnt_letters;
                continue;
            }
            if (Character.isDigit(c)) {
                ++cnt_digits;
                continue;
            }
            ++cnt_other;
        }
        if (log.isDebugEnabled()) {
            log.debug("t: " + term + " l: " + cnt_letters + " d: " + cnt_digits + " o: " + cnt_other);
        }
        if ((score = term.getScore()) > 0.0) {
            if (cnt_letters == 0) {
                term.multiplyScore(FACTOR_NO_LETTERS, "no letters");
            } else if (cnt_digits > 0 && cnt_other > 0) {
                term.multiplyScore(FACTOR_DIGITS_AND_OTHER, "digits and other chars");
            } else if (cnt_digits > 0) {
                term.multiplyScore(FACTOR_DIGITS, "contains digits");
            } else if (cnt_other > 0) {
                term.multiplyScore(FACTOR_OTHER, "contains other chars");
            }
        }
    }

    @Override
    public void endAnalysis() {
    }
}

