/*
 * #!
 * Ontopia Classify
 * #-
 * Copyright (C) 2001 - 2013 The Ontopia Project
 * #-
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *      http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * !#
 */

package net.ontopia.topicmaps.classify;

import org.apache.commons.lang3.StringUtils;

/**
 * INTERNAL: 
 */
public class JunkNormalizer implements TermNormalizerIF {
  
  @Override
  public String normalize(String term) {
    // strip out repeated whitespace characters
    term = StringUtils.normalizeSpace(term);
    // drop 's endings
    if (term.length() >= 2 && term.endsWith("'s")) {
      term = term.substring(0, term.length()-2);
    }
    return term;
  }
  
}
