/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.FormatModule;
import net.ontopia.topicmaps.classify.FormatModuleIF;
import net.ontopia.topicmaps.classify.TextHandlerIF;
import net.ontopia.utils.OntopiaRuntimeException;
import net.ontopia.xml.DefaultXMLReaderFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFormatModule
implements FormatModuleIF {
    protected Collection<String> skipElements;
    protected String[] extensions = new String[]{".xml"};
    protected byte[] magicBytes = FormatModule.getBytes("<?xml");

    public XMLFormatModule() {
        this.setSkipElements(Arrays.asList("sgml.block", "verbatim", "example", "sgml", "author", "bibliog", "web", "Authorinfo", "AuthorInfo", "AUTHORINFO", "code.block", "code.line", "Pre", "PRE", "programlisting", "acknowl", "code"));
    }

    public void setSkipElements(Collection<String> skipElements) {
        this.skipElements = new HashSet<String>(skipElements);
    }

    protected XMLReader createXMLReader() throws SAXException {
        return new DefaultXMLReaderFactory().createXMLReader();
    }

    protected ContentHandler getContentHandler(TextHandlerIF handler) {
        return new XMLHandler(handler);
    }

    @Override
    public boolean matchesContent(ClassifiableContentIF cc) {
        return FormatModule.startsWith(cc.getContent(), this.magicBytes);
    }

    @Override
    public boolean matchesIdentifier(ClassifiableContentIF cc) {
        return FormatModule.matchesExtension(cc.getIdentifier(), this.extensions);
    }

    @Override
    public void readContent(ClassifiableContentIF cc, TextHandlerIF handler) {
        try {
            XMLReader parser = this.createXMLReader();
            parser.setContentHandler(this.getContentHandler(handler));
            parser.parse(new InputSource(new BufferedInputStream(new ByteArrayInputStream(cc.getContent()))));
        }
        catch (SAXParseException e) {
            throw new OntopiaRuntimeException("XML parsing problem: " + e.toString() + " at: " + e.getSystemId() + ":" + e.getLineNumber() + ":" + e.getColumnNumber(), (Throwable)e);
        }
        catch (SAXException e) {
            if (e.getException() instanceof IOException) {
                throw new OntopiaRuntimeException((Throwable)((IOException)e.getException()));
            }
            throw new OntopiaRuntimeException((Throwable)e);
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    private class XMLHandler
    extends DefaultHandler {
        private TextHandlerIF thandler;
        private int skipLevel;

        private XMLHandler(TextHandlerIF thandler) {
            this.thandler = thandler;
        }

        public void startElement(String nsuri, String lname, String qname, Attributes attrs) throws SAXException {
            if (XMLFormatModule.this.skipElements != null && XMLFormatModule.this.skipElements.contains(lname)) {
                ++this.skipLevel;
            } else if (this.skipLevel == 0) {
                this.thandler.startRegion(lname);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.skipLevel == 0) {
                this.thandler.text(ch, start, length);
            }
        }

        public void endElement(String nsuri, String lname, String qname) throws SAXException {
            if (XMLFormatModule.this.skipElements != null && XMLFormatModule.this.skipElements.contains(lname)) {
                --this.skipLevel;
            } else if (this.skipLevel == 0) {
                this.thandler.endRegion();
            }
        }
    }
}

