/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.Token;
import net.ontopia.topicmaps.classify.Variant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TermDatabase {
    protected Map<String, Term> terms = new HashMap<String, Term>();
    protected Map<String, Variant> variants = new HashMap<String, Variant>();
    protected Map<String, Token> delimiter_terms = new HashMap<String, Token>();

    TermDatabase() {
    }

    public Collection<Term> getTerms() {
        return this.terms.values();
    }

    public Term[] getTermsByRank() {
        Term[] ranked = this.terms.values().toArray(new Term[0]);
        Arrays.sort(ranked, Term.SCORE_COMPARATOR);
        return ranked;
    }

    public int getTermCount() {
        return this.terms.size();
    }

    public Term getTerm(String stem) {
        return this.terms.get(stem);
    }

    public Variant getVariant(String variant) {
        return this.variants.get(variant);
    }

    protected Token createDelimiter(String delimiter) {
        Token token = this.delimiter_terms.get(delimiter);
        if (token == null) {
            token = new Token(delimiter, 2);
            this.delimiter_terms.put(delimiter, token);
        }
        return token;
    }

    protected void mergeTerms(Term t1, Term t2) {
        if (t1 == t2) {
            return;
        }
        t1.merge(t2);
        this.terms.remove(t2.getStem());
    }

    protected Term createTerm(String stem) {
        Term term = this.terms.get(stem);
        if (term == null) {
            term = new Term(stem);
            this.terms.put(stem, term);
        }
        return term;
    }

    protected double getMaxScore() {
        Term[] terms = this.getTermsByRank();
        if (terms.length == 0) {
            return 0.0;
        }
        return terms[0].getScore();
    }

    protected Variant createVariant(String variant) {
        Variant v = this.variants.get(variant);
        if (v == null) {
            v = new Variant(variant);
            this.variants.put(variant, v);
        }
        return v;
    }

    public void dump() {
        this.dump(-1);
    }

    public void dump(int firstN) {
        Term[] terms = this.getTermsByRank();
        int num = firstN <= 0 ? terms.length : Math.min(terms.length, firstN);
        for (int i = 0; i < num; ++i) {
            Term t = terms[i];
            System.out.println(Integer.toString(i + 1) + ": " + t.getPreferredName() + " " + t.getScore() + ", " + t.getOccurrences());
        }
        System.out.println("Total: " + terms.length + " terms.");
    }
}

