/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Comparator;
import net.ontopia.topicmaps.classify.Token;
import net.ontopia.topicmaps.classify.Variant;
import net.ontopia.utils.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Term {
    static Logger log = LoggerFactory.getLogger((String)Term.class.getName());
    protected String stem;
    protected double score = 1.0;
    protected int totalOccurrences;
    protected TObjectIntHashMap<Variant> variants = new TObjectIntHashMap();
    protected static Comparator<Term> SCORE_COMPARATOR = new Comparator<Term>(){

        @Override
        public int compare(Term t1, Term t2) {
            return ObjectUtils.compare((double)t2.getScore(), (double)t1.getScore());
        }
    };

    Term(String stem) {
        this.stem = stem;
    }

    public String getStem() {
        return this.stem;
    }

    public double getScore() {
        return this.score;
    }

    public Variant[] getVariants() {
        return (Variant[])this.variants.keys((Object[])new Variant[0]);
    }

    public Variant[] getVariantsByRank() {
        Variant[] ranked = this.getVariants();
        Arrays.sort(ranked, new VariantComparator());
        return ranked;
    }

    public int getOccurrences() {
        return this.totalOccurrences;
    }

    public String getPreferredName() {
        if (this.variants.isEmpty()) {
            return this.getStem();
        }
        Token maxKey = null;
        int maxValue = -1;
        TObjectIntIterator iter = this.variants.iterator();
        while (iter.hasNext()) {
            iter.advance();
            int thisValue = iter.value();
            Variant thisKey = (Variant)iter.key();
            if (thisValue <= maxValue && (thisValue != maxValue || thisKey.getValue().compareTo(maxKey.getValue()) >= 0)) continue;
            maxValue = thisValue;
            maxKey = thisKey;
        }
        return maxKey.getValue();
    }

    protected double getScore(Variant v) {
        return 1.0 * (double)this.getOccurrences(v) / (double)this.totalOccurrences;
    }

    protected int getOccurrences(Variant variant) {
        return this.variants.get((Object)variant);
    }

    protected void setScore(double score, String reason) {
        if (score <= 0.0) {
            throw new RuntimeException("Score is not nillable: " + score + " term: " + this);
        }
        log.debug(">" + this.stem + "< =" + score + ", " + reason);
        this.score = score;
    }

    protected void addScore(double ascore, String reason) {
        this.score += ascore;
        log.debug(">" + this.stem + "< +" + ascore + "=" + this.score + ", " + reason);
    }

    protected void multiplyScore(double factor, String reason) {
        this.score *= factor;
        log.debug(">" + this.stem + "< *" + factor + "=" + this.score + ", " + reason);
    }

    protected void divideScore(double factor, String reason) {
        this.score /= factor;
        log.debug(">" + this.stem + "< /" + factor + "=" + this.score + ", " + reason);
    }

    protected void addVariant(Variant variant) {
        this.addVariant(variant, 1);
    }

    protected void addVariant(Variant variant, int occurrences) {
        if (this.variants.get((Object)variant) > 0) {
            this.variants.increment((Object)variant);
        } else {
            this.variants.put((Object)variant, occurrences);
        }
        this.totalOccurrences += occurrences;
    }

    protected void merge(Term other) {
        if (other == this) {
            return;
        }
        this.score += other.score;
        this.totalOccurrences += other.totalOccurrences;
        TObjectIntIterator iter = other.variants.iterator();
        while (iter.hasNext()) {
            iter.advance();
            Variant key = (Variant)iter.key();
            int value = iter.value();
            if (this.variants.containsKey((Object)key)) {
                this.variants.adjustValue((Object)key, value);
            } else {
                this.variants.put((Object)key, value);
            }
            key.replaceTerm(this);
        }
    }

    public String toString() {
        return '\'' + this.getStem() + "'" + this.getScore() + ":" + (this.variants.isEmpty() ? "" : Arrays.asList(this.variants.keys()).toString());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class VariantComparator
    implements Comparator<Variant> {
        private VariantComparator() {
        }

        @Override
        public int compare(Variant v1, Variant v2) {
            int c = ObjectUtils.compare((int)Term.this.getOccurrences(v2), (int)Term.this.getOccurrences(v1));
            if (c != 0) {
                return c;
            }
            return v1.getValue().compareTo(v2.getValue());
        }
    }
}

