/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.HashSet;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermDatabase;
import net.ontopia.utils.OntopiaRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopList
implements TermAnalyzerIF {
    protected Collection<String> stopList;
    protected double stopFactor = 1.0E-4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StopList(String filename) {
        ClassLoader cloader = StopList.class.getClassLoader();
        if (cloader == null) {
            throw new OntopiaRuntimeException("Cannot find class loader.");
        }
        InputStream istream = cloader.getResourceAsStream(filename);
        if (istream == null) {
            throw new OntopiaRuntimeException("Cannot find resource: " + filename);
        }
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(istream));
            try {
                this.stopList = this.load(reader);
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StopList(File file) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            try {
                this.stopList = this.load(reader);
            }
            finally {
                reader.close();
            }
        }
        catch (IOException e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    private Collection<String> load(BufferedReader reader) throws IOException {
        HashSet<String> stopList = new HashSet<String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            stopList.add(line.trim().toLowerCase());
        }
        return stopList;
    }

    public void setStopFactor(double stopFactor) {
        this.stopFactor = stopFactor;
    }

    public boolean isStopWord(String word) {
        return this.stopList.contains(word);
    }

    @Override
    public void analyzeTerm(Term term) {
        if (this.isStopWord(term.getStem())) {
            term.multiplyScore(this.stopFactor, "stoplist adjustment");
        }
    }

    @Override
    public void startAnalysis(TermDatabase tdb) {
    }

    @Override
    public void endAnalysis() {
    }
}

