/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import gnu.trove.set.hash.TIntHashSet;
import net.ontopia.topicmaps.classify.DelimiterTrimmerIF;
import net.ontopia.topicmaps.classify.TermNormalizerIF;

public class SpecialCharNormalizer
implements TermNormalizerIF,
DelimiterTrimmerIF {
    private TIntHashSet prechars = new TIntHashSet();
    private TIntHashSet postchars = new TIntHashSet();

    public SpecialCharNormalizer() {
        this("<')(\"[ {\u00b7-%\u201c\u2018/$.,", ">')(.,\"':;!]? |}*\u00b7-%\u201d\u2019");
    }

    public SpecialCharNormalizer(String _prechars, String _postchars) {
        this(_prechars == null ? null : _prechars.toCharArray(), _postchars == null ? null : _postchars.toCharArray());
    }

    public SpecialCharNormalizer(char[] _prechars, char[] _postchars) {
        int i;
        if (_prechars != null) {
            for (i = 0; i < _prechars.length; ++i) {
                this.prechars.add((int)_prechars[i]);
            }
        }
        if (_postchars != null) {
            for (i = 0; i < _postchars.length; ++i) {
                this.postchars.add((int)_postchars[i]);
            }
        }
    }

    public String normalize(String term) {
        int i;
        int length = term.length();
        int start = 0;
        int end = length - 1;
        for (i = start; i < end; ++i) {
            if (this.prechars.contains((int)term.charAt(i))) continue;
            start = i;
            break;
        }
        for (i = end; i >= start; --i) {
            if (this.postchars.contains((int)term.charAt(i))) continue;
            end = i;
            break;
        }
        if (start == end) {
            return null;
        }
        if (start == 0 && end == length) {
            return term;
        }
        return term.substring(start, end + 1);
    }

    public int trimStart(String token) {
        int start = 0;
        int end = token.length() - 1;
        for (int i = start; i < end + 1; ++i) {
            if (this.prechars.contains((int)token.charAt(i))) continue;
            start = i;
            break;
        }
        return start;
    }

    public int trimEnd(String token) {
        int end;
        for (int i = end = token.length() - 1; i >= 0; --i) {
            if (this.postchars.contains((int)token.charAt(i))) continue;
            end = i;
            break;
        }
        return end;
    }
}

