/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.HashMap;
import java.util.Map;
import net.ontopia.topicmaps.classify.TermStemmerIF;
import net.ontopia.utils.OntopiaRuntimeException;
import org.tartarus.snowball.SnowballProgram;

public class SnowballStemmer
implements TermStemmerIF {
    private static Map<String, String> languages = new HashMap<String, String>();
    protected SnowballProgram stemmer;

    public SnowballStemmer(String lang) {
        String stemClassName = languages.get(lang);
        if (stemClassName == null) {
            throw new OntopiaRuntimeException("Unknown language: '" + lang + "'");
        }
        try {
            Class<?> stemClass = Class.forName(stemClassName);
            this.stemmer = (SnowballProgram)stemClass.newInstance();
        }
        catch (Exception e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    public String stem(String term) {
        this.stemmer.setCurrent(term);
        this.stemmer.stem();
        String stem = this.stemmer.getCurrent();
        return stem == null ? null : stem.toLowerCase();
    }

    static {
        languages.put("dk", "org.tartarus.snowball.ext.DanishStemmer");
        languages.put("nl", "org.tartarus.snowball.ext.DutchStemmer");
        languages.put("en", "org.tartarus.snowball.ext.EnglishStemmer");
        languages.put("fi", "org.tartarus.snowball.ext.FinnishStemmer");
        languages.put("fr", "org.tartarus.snowball.ext.FrenchStemmer");
        languages.put("de2", "org.tartarus.snowball.ext.German2Stemmer");
        languages.put("de", "org.tartarus.snowball.ext.GermanStemmer");
        languages.put("it", "org.tartarus.snowball.ext.ItalianStemmer");
        languages.put("kp", "org.tartarus.snowball.ext.KpStemmer");
        languages.put("lovins", "org.tartarus.snowball.ext.LovinsStemmer");
        languages.put("no", "org.tartarus.snowball.ext.NorwegianStemmer");
        languages.put("porter", "org.tartarus.snowball.ext.PorterStemmer");
        languages.put("pt", "org.tartarus.snowball.ext.PortugueseStemmer");
        languages.put("ru", "org.tartarus.snowball.ext.RussianStemmer");
        languages.put("es", "org.tartarus.snowball.ext.SpanishStemmer");
        languages.put("se", "org.tartarus.snowball.ext.SwedishStemmer");
    }
}

