/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.HashMap;
import java.util.Map;
import net.ontopia.topicmaps.classify.AbstractDocumentAnalyzer;
import net.ontopia.topicmaps.classify.Region;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TextBlock;
import net.ontopia.topicmaps.classify.Token;
import net.ontopia.topicmaps.classify.Variant;

public class RegionBooster
extends AbstractDocumentAnalyzer {
    Map<String, Double> regions = new HashMap<String, Double>();
    double boost = 1.0;

    public RegionBooster() {
        super(1);
    }

    public void addBoost(String rname, double boost) {
        this.regions.put(rname, new Double(boost));
    }

    public void startRegion(Region region) {
        super.startRegion(region);
        String rname = region.getName();
        Double d = this.regions.get(rname);
        this.boost = d != null ? d : 1.0;
    }

    public void analyzeToken(TextBlock parent, Token token, int index) {
        if (token.getType() != 1) {
            return;
        }
        Term term = ((Variant)token).getTerm();
        double score = term.getScore();
        if (score > 0.0) {
            term.multiplyScore(this.boost, "region boost");
        }
    }

    public void endRegion(Region region) {
        super.endRegion(region);
    }
}

