/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermDatabase;

public class RegexpTermAnalyzer
implements TermAnalyzerIF {
    private List<Rule> rules = new ArrayList<Rule>();

    public RegexpTermAnalyzer() {
        this.rules.add(new Rule("email address", "[-A-Za-z.0-9]+@([-A-Za-z.0-9]+\\.)+[A-Za-z]+", 0.002));
        this.rules.add(new Rule("http URL", "http://[-.A-Za-z?+&=0-9#/]+", 0.002));
    }

    public void startAnalysis(TermDatabase tdb) {
    }

    public void analyzeTerm(Term term) {
        for (int ix = 0; ix < this.rules.size(); ++ix) {
            Rule rule = this.rules.get(ix);
            if (!rule.matches(term)) continue;
            term.multiplyScore(rule.getFactor(), "matched " + rule.getName() + " rule");
        }
    }

    public void endAnalysis() {
    }

    static class Rule {
        private String name;
        private Pattern pattern;
        private double factor;

        public Rule(String name, String pattern, double factor) {
            this.name = name;
            this.pattern = Pattern.compile(pattern);
            this.factor = factor;
        }

        public boolean matches(Term term) {
            return this.pattern.matcher(term.getPreferredName()).matches();
        }

        public String getName() {
            return this.name;
        }

        public double getFactor() {
            return this.factor;
        }
    }
}

