/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.io.UnsupportedEncodingException;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.FormatModule;
import net.ontopia.topicmaps.classify.FormatModuleIF;
import net.ontopia.topicmaps.classify.TextHandlerIF;
import net.ontopia.utils.OntopiaRuntimeException;

public class PlainTextFormatModule
implements FormatModuleIF {
    protected String[] extensions = new String[]{".txt"};

    public boolean matchesContent(ClassifiableContentIF cc) {
        return false;
    }

    public boolean matchesIdentifier(ClassifiableContentIF cc) {
        return FormatModule.matchesExtension(cc.getIdentifier(), this.extensions);
    }

    public void readContent(ClassifiableContentIF cc, TextHandlerIF handler) {
        try {
            int charSetId = FormatModule.detectCharSet(cc.getContent());
            handler.startRegion("document");
            if (charSetId >= 0) {
                String charSet = FormatModule.getCharSetName(charSetId);
                int offset = FormatModule.getOffset(charSetId);
                String s = new String(cc.getContent(), charSet);
                char[] c = s.toCharArray();
                handler.text(c, offset, c.length - offset);
            } else {
                String s = new String(cc.getContent());
                char[] c = s.toCharArray();
                handler.text(c, 0, c.length);
            }
            handler.endRegion();
        }
        catch (UnsupportedEncodingException e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }
}

