/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.ArrayList;
import java.util.List;
import net.ontopia.topicmaps.classify.Document;
import net.ontopia.topicmaps.classify.FrequencyAnalyzer;
import net.ontopia.topicmaps.classify.SnowballStemmer;
import net.ontopia.topicmaps.classify.StopList;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermStemmerIF;
import net.ontopia.topicmaps.classify.Token;
import net.ontopia.topicmaps.classify.TokenVisitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Language {
    static Logger log = LoggerFactory.getLogger((String)Language.class.getName());
    private static List<Language> languages = new ArrayList<Language>();
    protected String id;
    protected TermStemmerIF stemmer;
    protected StopList stoplist;
    protected FrequencyAnalyzer frequency;

    Language(String id) {
        this.id = id;
        this.stemmer = new SnowballStemmer(id);
        this.frequency = new FrequencyAnalyzer("net/ontopia/topicmaps/classify/lang/" + id + ".freq");
        this.stoplist = new StopList("net/ontopia/topicmaps/classify/lang/" + id + ".stop");
    }

    public Language(String id, TermStemmerIF stemmer, StopList stoplist, FrequencyAnalyzer frequency) {
        this.id = id;
        this.stemmer = stemmer;
        this.stoplist = stoplist;
        this.frequency = frequency;
    }

    public TermStemmerIF getStemmer() {
        return this.stemmer;
    }

    public TermAnalyzerIF getStopListAnalyzer() {
        return this.stoplist;
    }

    public TermAnalyzerIF getFrequencyAnalyzer() {
        return this.frequency;
    }

    public int getScore(Document doc) {
        StopWordCounter slc = new StopWordCounter();
        slc.stoplist = this.stoplist;
        doc.visitTokens(slc);
        return slc.count;
    }

    public String toString() {
        return "Language[" + this.id + "]";
    }

    public static Language getLanguage(String lang) {
        return new Language(lang);
    }

    public static void registerLanguage(Language lang) {
        languages.add(lang);
    }

    public static Language detectLanguage(Document doc) {
        Language high = null;
        int highscore = -1;
        for (Language lang : languages) {
            int score = lang.getScore(doc);
            log.debug("Score '" + lang + "'=" + score);
            if (score < highscore) continue;
            highscore = score;
            high = lang;
        }
        log.debug("Detected language '" + high + "'");
        return high;
    }

    static {
        languages.add(Language.getLanguage("en"));
        languages.add(Language.getLanguage("no"));
    }

    static class StopWordCounter
    extends TokenVisitor {
        StopList stoplist;
        int count;

        StopWordCounter() {
        }

        public void visit(Token token) {
            if (token.getType() == 1 && this.stoplist.isStopWord(token.getValue())) {
                ++this.count;
            }
        }
    }
}

