/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.Arrays;
import net.ontopia.topicmaps.classify.ClassifiableContentIF;
import net.ontopia.topicmaps.classify.FormatModule;
import net.ontopia.topicmaps.classify.TextHandlerIF;
import net.ontopia.topicmaps.classify.XMLFormatModule;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HTMLFormatModule
extends XMLFormatModule {
    protected byte[][] magicBytes = FormatModule.getBytes(new String[]{"<HTML", "<html", "<!DOCTYPE html ", "<!DOCTYPE HTML ", "<!DOCTYPE HTML ", "<!doctype html "});

    public HTMLFormatModule() {
        this.extensions = new String[]{".htm", ".html", ".xhtml", ".shtml"};
        this.setSkipElements(Arrays.asList("style", "STYLE", "pre", "PRE", "script", "SCRIPT"));
    }

    public boolean matchesContent(ClassifiableContentIF cc) {
        return FormatModule.startsWithSkipWhitespace(cc.getContent(), this.magicBytes);
    }

    protected XMLReader createXMLReader() throws SAXException {
        return new Parser();
    }

    protected ContentHandler getContentHandler(TextHandlerIF handler) {
        return new HTMLHandler(handler);
    }

    private class HTMLHandler
    extends DefaultHandler {
        private TextHandlerIF thandler;
        private int skipLevel;

        private HTMLHandler(TextHandlerIF thandler) {
            this.thandler = thandler;
        }

        public void startElement(String nsuri, String lname, String qname, Attributes attrs) throws SAXException {
            if (HTMLFormatModule.this.skipElements != null && HTMLFormatModule.this.skipElements.contains(lname)) {
                ++this.skipLevel;
            } else if (this.skipLevel == 0) {
                this.thandler.startRegion(lname);
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.skipLevel == 0) {
                this.thandler.text(ch, start, length);
            }
        }

        public void endElement(String nsuri, String lname, String qname) throws SAXException {
            if (HTMLFormatModule.this.skipElements != null && HTMLFormatModule.this.skipElements.contains(lname)) {
                --this.skipLevel;
            } else if (this.skipLevel == 0) {
                this.thandler.endRegion();
            }
        }
    }
}

