/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import au.com.bytecode.opencsv.CSVReader;
import gnu.trove.map.hash.TObjectDoubleHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermDatabase;
import net.ontopia.topicmaps.classify.Variant;
import net.ontopia.utils.OntopiaRuntimeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrequencyAnalyzer
implements TermAnalyzerIF {
    protected TObjectDoubleHashMap<String> freqs;

    public FrequencyAnalyzer(String filename) {
        ClassLoader cloader = FrequencyAnalyzer.class.getClassLoader();
        if (cloader == null) {
            throw new OntopiaRuntimeException("Cannot find class loader.");
        }
        InputStream istream = cloader.getResourceAsStream(filename);
        if (istream == null) {
            throw new OntopiaRuntimeException("Cannot find resource: " + filename);
        }
        this.freqs = this.load(istream);
    }

    public FrequencyAnalyzer(File file) {
        FileInputStream istream = null;
        try {
            istream = new FileInputStream(file);
            this.freqs = this.load(istream);
        }
        catch (IOException e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TObjectDoubleHashMap<String> load(InputStream istream) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(istream, "utf-8"));
            TObjectDoubleHashMap freqs = new TObjectDoubleHashMap();
            char separator = ';';
            char quoteCharacter = '\"';
            CSVReader csv = new CSVReader((Reader)reader, separator, quoteCharacter);
            try {
                String[] tuple = null;
                while ((tuple = csv.readNext()) != null) {
                    String term = tuple[0].toLowerCase();
                    double factor = Double.parseDouble(tuple[1]);
                    freqs.put((Object)term, factor);
                }
            }
            finally {
                csv.close();
            }
            TObjectDoubleHashMap tObjectDoubleHashMap = freqs;
            return tObjectDoubleHashMap;
        }
        catch (IOException e) {
            throw new OntopiaRuntimeException((Throwable)e);
        }
        finally {
            try {
                istream.close();
            }
            catch (IOException e) {
                throw new OntopiaRuntimeException((Throwable)e);
            }
        }
    }

    @Override
    public void analyzeTerm(Term term) {
        double total = 0.0;
        Variant[] variants = term.getVariants();
        for (int i = 0; i < variants.length; ++i) {
            Variant variant = variants[i];
            double freq = this.freqs.get((Object)variant.getValue().toLowerCase());
            if (freq > 0.0) {
                total += freq;
                continue;
            }
            total += 1.0;
        }
        double average = total / (double)variants.length;
        if (average > 0.0) {
            term.multiplyScore(average, "frequency adjustment");
        }
    }

    @Override
    public void startAnalysis(TermDatabase tdb) {
    }

    @Override
    public void endAnalysis() {
    }
}

