/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import java.util.ArrayList;
import java.util.List;
import net.ontopia.topicmaps.classify.CompoundAnalyzer;
import net.ontopia.topicmaps.classify.Document;
import net.ontopia.topicmaps.classify.DocumentAnalyzerIF;
import net.ontopia.topicmaps.classify.Region;
import net.ontopia.topicmaps.classify.Term;
import net.ontopia.topicmaps.classify.TermAnalyzerIF;
import net.ontopia.topicmaps.classify.TermDatabase;
import net.ontopia.topicmaps.classify.TermStemmerIF;
import net.ontopia.topicmaps.classify.TextBlock;
import net.ontopia.topicmaps.classify.Token;
import net.ontopia.topicmaps.classify.Variant;

public class DocumentClassifier {
    TermDatabase tdb;
    TermStemmerIF termStemmer;
    List<DocumentAnalyzerIF> docAnalyzers = new ArrayList<DocumentAnalyzerIF>();
    List<TermAnalyzerIF> termAnalyzers = new ArrayList<TermAnalyzerIF>();

    public DocumentClassifier(TermDatabase tdb) {
        this.tdb = tdb;
    }

    public TermDatabase getTermDatabase() {
        return this.tdb;
    }

    public void setTermDatabase(TermDatabase tdb) {
        this.tdb = tdb;
    }

    public void setTermStemmer(TermStemmerIF stemmer) {
        this.termStemmer = stemmer;
    }

    public void addDocumentAnalyzer(DocumentAnalyzerIF analyzer) {
        this.docAnalyzers.add(analyzer);
    }

    public void addTermAnalyzer(TermAnalyzerIF analyzer) {
        this.termAnalyzers.add(analyzer);
    }

    protected void extractTerms(Document doc) {
        this.extractTerms(doc.getRoot());
    }

    protected void extractTerms(Region region) {
        for (Object child : region.getChildren()) {
            if (child instanceof TextBlock) {
                TextBlock tb = (TextBlock)child;
                this.extractTerms(region, tb);
                continue;
            }
            Region tr = (Region)child;
            this.extractTerms(tr);
        }
    }

    protected void extractTerms(Region parent, TextBlock tb) {
        for (Token token : tb.getTokens()) {
            if (token.getType() != 1) continue;
            Variant variant = (Variant)token;
            Term term = variant.getTerm();
            if (term == null) {
                String normalized = token.getValue();
                String stem = this.termStemmer.stem(normalized);
                term = this.tdb.createTerm(stem);
                variant.setTerm(term);
            }
            term.addVariant(variant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeDocument(Document doc) {
        this.extractTerms(doc);
        if (this.docAnalyzers != null && !this.docAnalyzers.isEmpty()) {
            Region root = doc.getRoot();
            for (DocumentAnalyzerIF analyzer : this.docAnalyzers) {
                analyzer.startAnalysis();
                try {
                    while (analyzer.doDocumentAnalysis()) {
                        analyzer.startDocument(doc);
                        this.analyzeRegion(root, analyzer);
                        analyzer.endDocument(doc);
                    }
                }
                finally {
                    analyzer.endAnalysis();
                }
            }
        }
    }

    protected void analyzeRegion(Region region, DocumentAnalyzerIF analyzer) {
        analyzer.startRegion(region);
        for (Object child : region.getChildren()) {
            if (child instanceof TextBlock) {
                TextBlock tb = (TextBlock)child;
                this.analyzeTextBlock(region, tb, analyzer);
                continue;
            }
            Region tr = (Region)child;
            this.analyzeRegion(tr, analyzer);
        }
        analyzer.endRegion(region);
    }

    protected void analyzeTextBlock(Region parent, TextBlock tb, DocumentAnalyzerIF analyzer) {
        List<Token> tokens = tb.getTokens();
        int size = tokens.size();
        for (int i = 0; i < size; ++i) {
            Token t = tokens.get(i);
            analyzer.analyzeToken(tb, t, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void analyzeTerms() {
        if (this.termAnalyzers != null && !this.termAnalyzers.isEmpty()) {
            for (TermAnalyzerIF analyzer : this.termAnalyzers) {
                analyzer.startAnalysis(this.tdb);
                try {
                    Term[] terms = this.tdb.getTerms().toArray(new Term[0]);
                    for (int x = 0; x < terms.length; ++x) {
                        analyzer.analyzeTerm(terms[x]);
                    }
                }
                finally {
                    analyzer.endAnalysis();
                }
            }
        }
    }

    public void dump() {
        for (TermAnalyzerIF ta : this.termAnalyzers) {
            if (!(ta instanceof CompoundAnalyzer)) continue;
            CompoundAnalyzer ca = (CompoundAnalyzer)ta;
            Term[] terms = this.tdb.getTermsByRank();
            for (int i = 0; i < terms.length; ++i) {
                ca.dump(terms[i]);
            }
        }
    }
}

