/*
 * Decompiled with CFR 0.152.
 */
package net.ontopia.topicmaps.classify;

import net.ontopia.topicmaps.classify.Region;
import net.ontopia.topicmaps.classify.TextHandlerIF;
import net.ontopia.topicmaps.classify.TokenVisitor;
import net.ontopia.utils.OntopiaRuntimeException;

public class Document
implements TextHandlerIF {
    private Region root;
    private Region current;
    private boolean tokenized;

    Document() {
        this.current = this.root = new Region();
    }

    public Region getRoot() {
        return this.root;
    }

    public void startRegion(String regionName) {
        Region region = new Region(regionName);
        region.setParent(this.current);
        this.current = region;
    }

    public void text(char[] ch, int start, int length) {
        this.current.addText(ch, start, length);
    }

    public void endRegion() {
        Region parent = this.current.getParent();
        parent.addRegion(this.current);
        this.current = parent;
    }

    public void dump() {
        this.root.dump();
    }

    public void visitTokens(TokenVisitor visitor) {
        this.root.visitTokens(visitor);
    }

    public void setTokenized(boolean tokenized) {
        if (this.tokenized) {
            throw new OntopiaRuntimeException("Cannot tokenize document more than once.");
        }
        this.tokenized = tokenized;
    }
}

